/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.crawler.web.parse;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.connectivity.framework.crawler.web.parse.Parser;
import org.eclipse.smila.connectivity.framework.crawler.web.parse.ParserManager;

public class ParserManagerImpl
implements ParserManager {
    private List<Parser> _parsers = new ArrayList<Parser>();
    private final Log _log = LogFactory.getLog(ParserManagerImpl.class);

    @Override
    public void addParser(Parser parser) {
        this._parsers.add(parser);
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("adding webcrawler parser: " + parser.getClass().getName()));
        }
    }

    @Override
    public void removeParser(Parser parser) {
        this._parsers.remove(parser);
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("removing webcrawler parser: " + parser.getClass().getName()));
        }
    }

    @Override
    public Parser getParser(String contentType) {
        if (contentType != null) {
            for (Parser parser : this._parsers) {
                String[] contentTypes = parser.getContentTypes();
                if (contentTypes == null) continue;
                String[] stringArray = contentTypes;
                int n = contentTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    String parserContentType = stringArray[n2];
                    if (contentType.toLowerCase().startsWith(parserContentType)) {
                        return parser;
                    }
                    ++n2;
                }
            }
        }
        return null;
    }

    @Override
    public Parser getParser(Class clazz) {
        for (Parser parser : this._parsers) {
            if (!parser.getClass().equals(clazz)) continue;
            return parser;
        }
        return null;
    }
}

