/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.crawler.web.parse.html;

import java.net.URL;
import org.eclipse.smila.connectivity.framework.crawler.web.parse.html.HTMLMetaTags;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class HTMLMetaProcessor {
    private HTMLMetaProcessor() {
    }

    public static void getMetaTags(HTMLMetaTags metaTags, Node node, URL currURL) {
        metaTags.reset();
        HTMLMetaProcessor.getMetaTagsHelper(metaTags, node, currURL);
    }

    private static void getMetaTagsHelper(HTMLMetaTags metaTags, Node node, URL currURL) {
        NodeList children;
        if (node.getNodeType() == 1) {
            Node hrefNode;
            NamedNodeMap attrs;
            if ("body".equalsIgnoreCase(node.getNodeName())) {
                return;
            }
            if ("meta".equalsIgnoreCase(node.getNodeName())) {
                attrs = node.getAttributes();
                Node nameNode = null;
                Node equivNode = null;
                Node contentNode = null;
                int i = 0;
                while (i < attrs.getLength()) {
                    Node attr = attrs.item(i);
                    String attrName = attr.getNodeName().toLowerCase();
                    if (attrName.equals("name")) {
                        nameNode = attr;
                    } else if (attrName.equals("http-equiv")) {
                        equivNode = attr;
                    } else if (attrName.equals("content")) {
                        contentNode = attr;
                    }
                    ++i;
                }
                if (nameNode != null && contentNode != null) {
                    String name = nameNode.getNodeValue().toLowerCase();
                    metaTags.getGeneralTags().setProperty(name, contentNode.getNodeValue());
                    if ("robots".equals(name)) {
                        String directives = contentNode.getNodeValue().toLowerCase();
                        int index = directives.indexOf("none");
                        if (index >= 0) {
                            metaTags.setNoIndex();
                            metaTags.setNoFollow();
                        }
                        if ((index = directives.indexOf("all")) >= 0) {
                            // empty if block
                        }
                        if ((index = directives.indexOf("noindex")) >= 0) {
                            metaTags.setNoIndex();
                        }
                        if ((index = directives.indexOf("nofollow")) >= 0) {
                            metaTags.setNoFollow();
                        }
                    }
                }
                if (equivNode != null && contentNode != null) {
                    String name = equivNode.getNodeValue().toLowerCase();
                    String content = contentNode.getNodeValue();
                    metaTags.getHttpEquivTags().setProperty(name, content);
                    if ("pragma".equals(name)) {
                        int index = (content = content.toLowerCase()).indexOf("no-cache");
                        if (index >= 0) {
                            metaTags.setNoCache();
                        }
                    } else if ("refresh".equals(name)) {
                        int idx = content.indexOf(59);
                        String time = null;
                        time = idx == -1 ? content : content.substring(0, idx);
                        try {
                            metaTags.setRefreshTime(Integer.parseInt(time));
                            metaTags.setRefresh(true);
                        }
                        catch (Exception exception) {}
                        URL refreshUrl = null;
                        if (metaTags.getRefresh() && idx != -1) {
                            idx = content.toLowerCase().indexOf("url=");
                            idx = idx == -1 ? content.indexOf(59) + 1 : (idx += 4);
                            if (idx != -1) {
                                String url = content.substring(idx);
                                try {
                                    refreshUrl = new URL(url);
                                }
                                catch (Exception exception) {
                                    try {
                                        refreshUrl = new URL(currURL, url);
                                    }
                                    catch (Exception exception2) {
                                        refreshUrl = null;
                                    }
                                }
                            }
                        }
                        if (metaTags.getRefresh()) {
                            if (refreshUrl == null) {
                                refreshUrl = currURL;
                            }
                            metaTags.setRefreshHref(refreshUrl);
                        }
                    }
                }
            } else if ("base".equalsIgnoreCase(node.getNodeName()) && (hrefNode = (attrs = node.getAttributes()).getNamedItem("href")) != null) {
                String urlString = hrefNode.getNodeValue();
                URL url = null;
                try {
                    url = currURL == null ? new URL(urlString) : new URL(currURL, urlString);
                }
                catch (Exception exception) {}
                if (url != null) {
                    metaTags.setBaseHref(url);
                }
            }
        }
        if ((children = node.getChildNodes()) != null) {
            int len = children.getLength();
            int i = 0;
            while (i < len) {
                HTMLMetaProcessor.getMetaTagsHelper(metaTags, children.item(i), currURL);
                ++i;
            }
        }
    }
}

