/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.crawler.web.util;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class StringUtil {
    private static Map<String, String> encodingAliases = new HashMap<String, String>();

    static {
        encodingAliases.put("ISO-8859-1", "windows-1252");
        encodingAliases.put("EUC-KR", "x-windows-949");
        encodingAliases.put("x-EUC-CN", "GB18030");
        encodingAliases.put("GBK", "GB18030");
    }

    public static String parseCharacterEncoding(String contentType) {
        if (contentType == null) {
            return null;
        }
        int start = contentType.indexOf("charset=");
        if (start < 0) {
            return null;
        }
        String encoding = contentType.substring(start + 8);
        int end = encoding.indexOf(59);
        if (end >= 0) {
            encoding = encoding.substring(0, end);
        }
        if ((encoding = encoding.trim()).length() > 2 && encoding.startsWith("\"") && encoding.endsWith("\"")) {
            encoding = encoding.substring(1, encoding.length() - 1);
        }
        return encoding.trim();
    }

    public static String resolveEncodingAlias(String encoding) {
        if (!Charset.isSupported(encoding)) {
            return null;
        }
        String canonicalName = new String(Charset.forName(encoding).name());
        if (encodingAliases.containsKey(canonicalName)) {
            return encodingAliases.get(canonicalName);
        }
        return canonicalName;
    }
}

