/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.queue.worker.internal;

import org.eclipse.smila.connectivity.queue.worker.internal.AbstractQueueServicesAccessPoint;
import org.eclipse.smila.connectivity.queue.worker.internal.LocalUtils;
import org.osgi.service.component.ComponentContext;

public abstract class AbstractQueueService<ConfigType>
extends AbstractQueueServicesAccessPoint {
    protected ConfigType _config;

    public AbstractQueueService(String id) {
        super(id);
    }

    public abstract String getConfigName();

    @Override
    public void start() {
        super.start();
        this._config = LocalUtils.loadConfig(this.getConfigName());
    }

    @Override
    public void stop() {
        super.stop();
        this._config = null;
    }

    protected synchronized void activate(ComponentContext context) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Activating " + this.getClass()));
        }
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            try {
                this.start();
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("Activation of " + this.getClass() + " was successfull"));
                }
            }
            catch (RuntimeException e) {
                this._log.error((Object)("Activation of " + this.getClass() + " was fail"), (Throwable)e);
                throw e;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }

    protected synchronized void deactivate(ComponentContext context) {
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.getManagementLock().lock();
        try {
            this.stop();
        }
        finally {
            this.getManagementLock().unlock();
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }
}

