/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.queue.worker.internal.recycler;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.jms.Message;
import org.eclipse.smila.connectivity.queue.worker.Operation;
import org.eclipse.smila.connectivity.queue.worker.RecordRecyclerException;
import org.eclipse.smila.connectivity.queue.worker.RecordRecyclerStatus;
import org.eclipse.smila.connectivity.queue.worker.config.RecordRecyclerConfigType;
import org.eclipse.smila.connectivity.queue.worker.config.RecordRecyclerRuleType;
import org.eclipse.smila.connectivity.queue.worker.internal.AbstractQueueService;
import org.eclipse.smila.connectivity.queue.worker.internal.ServicesAccessPoint;
import org.eclipse.smila.connectivity.queue.worker.internal.recycler.Recycler;
import org.eclipse.smila.connectivity.queue.worker.internal.recycler.RecyclerRule;
import org.eclipse.smila.connectivity.queue.worker.internal.task.TaskListExecutionService;
import org.eclipse.smila.connectivity.queue.worker.jms.BrokerConnectionService;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.jms.MessageSelectorEvalHelper;
import org.eclipse.smila.processing.WorkflowProcessor;
import org.eclipse.smila.recordstorage.RecordStorage;
import org.eclipse.smila.recordstorage.RecordStorageException;

public class RecyclerImpl
extends AbstractQueueService<RecordRecyclerConfigType>
implements Recycler {
    private final String _configName;
    private final Set<RecyclerRule> _rules = new LinkedHashSet<RecyclerRule>();
    private final ServicesAccessPoint _accessPoint;
    private Iterator<Record> _iterator;
    private final String _dataSourceId;
    private long _recordNumber;
    private RecordRecyclerStatus _status;
    private final Object _statusMonitor = new Object();

    public RecyclerImpl(String configName, ServicesAccessPoint accessPoint, String dataSourceId) {
        super("RecordRecycler");
        this._configName = configName;
        this._accessPoint = accessPoint;
        this._dataSourceId = dataSourceId;
    }

    @Override
    public String getConfigName() {
        return String.format("recyclers/%s.xml", this._configName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void start() {
        this._log.info((Object)this.msg("Starting..."));
        HashSet<String> names = new HashSet<String>();
        this._rules.clear();
        try {
            Object ruleConfig2;
            super.start();
            for (Object ruleConfig2 : ((RecordRecyclerConfigType)this._config).getRule()) {
                if (names.contains(ruleConfig2.getName())) {
                    throw new RecordRecyclerException(String.format("Wrong configuration: rule name %s is not unique", ruleConfig2.getName()));
                }
                names.add(ruleConfig2.getName());
                this._rules.add(new RecyclerRule((ServicesAccessPoint)this, (RecordRecyclerRuleType)ruleConfig2));
            }
            ruleConfig2 = this._statusMonitor;
            synchronized (ruleConfig2) {
                this._status = RecordRecyclerStatus.STARTED;
            }
            this._log.info((Object)this.msg(String.format("Started successfully, found %d rules", this._rules.size())));
        }
        catch (Throwable e) {
            this._log.error((Object)this.msg("Error starting"), e);
            throw new RuntimeException(e);
        }
        try {
            this._iterator = this.getRecordsIterator(this._dataSourceId);
        }
        catch (RecordRecyclerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void stop() {
        this._rules.clear();
        super.stop();
        this._status = RecordRecyclerStatus.FINISHED;
    }

    @Override
    public long getRecordsRecycled() {
        return this._recordNumber;
    }

    @Override
    public RecordRecyclerStatus getStatus() {
        return this._status;
    }

    @Override
    public RecordStorage getRecordStorage() {
        return this._accessPoint.getRecordStorage();
    }

    @Override
    public WorkflowProcessor getWorkflowProcessor() {
        return this._accessPoint.getWorkflowProcessor();
    }

    @Override
    public BrokerConnectionService getBrokerConnections() {
        return this._accessPoint.getBrokerConnections();
    }

    @Override
    public TaskListExecutionService getTaskListExecutionService() {
        return this._accessPoint.getTaskListExecutionService();
    }

    private Iterator<Record> getRecordsIterator(String dataSourceId) throws RecordRecyclerException {
        Iterator iterator;
        try {
            iterator = this.getRecordStorage().loadRecords(dataSourceId);
        }
        catch (RecordStorageException e) {
            throw new RecordRecyclerException((Throwable)e);
        }
        if (!iterator.hasNext()) {
            throw new RecordRecyclerException(String.format("No one record found under %s data source!", dataSourceId));
        }
        return iterator;
    }

    private Message prepateDummyMessage(Record record, Operation operation) throws RecordRecyclerException {
        Message message = MessageSelectorEvalHelper.createDummyMessage();
        try {
            message.setStringProperty("Operation", operation.toString());
            if (record != null && record.getSource() != null) {
                message.setStringProperty("DataSourceID", record.getSource());
            }
        }
        catch (Throwable e) {
            throw new RecordRecyclerException(e);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recycle() throws RecordRecyclerException {
        Object object;
        Object object2 = this._statusMonitor;
        synchronized (object2) {
            this._status = RecordRecyclerStatus.IN_PROGRESS;
        }
        Operation operation = Operation.ADD;
        block11: while (this._iterator.hasNext()) {
            object = this._statusMonitor;
            synchronized (object) {
                if (this._status == RecordRecyclerStatus.STOPPING) {
                    this._log.info((Object)String.format("Recycling for data source [%s] is stopped", this._dataSourceId));
                    break;
                }
                this._log.info((Object)("CONtinue " + this._status));
            }
            Record record = this._iterator.next();
            ++this._recordNumber;
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("repeating " + record.getId()));
            }
            try {
                Message message = this.prepateDummyMessage(record, operation);
                for (RecyclerRule rule : this._rules) {
                    if (!rule.isApplied(message)) continue;
                    rule.process(record);
                    continue block11;
                }
            }
            catch (Throwable e) {
                this._log.error((Object)"", e);
            }
        }
        object = this._statusMonitor;
        synchronized (object) {
            this._status = this._status == RecordRecyclerStatus.STOPPING ? RecordRecyclerStatus.STOPPED : RecordRecyclerStatus.FINISHED;
        }
        this._log.info((Object)"Recycling was finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.recycle();
        }
        catch (Throwable e) {
            Object object = this._statusMonitor;
            synchronized (object) {
                this._status = RecordRecyclerStatus.EXCEPTION;
            }
            this._log.error((Object)"Recycling was finished unsuccessfully", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopRecycle() throws RecordRecyclerException {
        Object object = this._statusMonitor;
        synchronized (object) {
            if (this._status == RecordRecyclerStatus.STARTED || this._status == RecordRecyclerStatus.IN_PROGRESS) {
                this._status = RecordRecyclerStatus.STOPPING;
            }
        }
    }
}

