/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.queue.worker.internal.task.impl;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.connectivity.queue.worker.config.PropertyType;
import org.eclipse.smila.connectivity.queue.worker.config.QueueConnectionType;
import org.eclipse.smila.connectivity.queue.worker.config.SendType;
import org.eclipse.smila.connectivity.queue.worker.internal.task.AbstractTask;
import org.eclipse.smila.connectivity.queue.worker.internal.task.TaskExecutionEnv;
import org.eclipse.smila.connectivity.queue.worker.internal.task.TaskExecutionException;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.filter.RecordFilterNotFoundException;
import org.eclipse.smila.datamodel.xml.XmlSerializationUtils;

public class Send
extends AbstractTask<SendType> {
    public Send() {
        super("TASK/Send");
    }

    @Override
    public String[] executeInternal(TaskExecutionEnv env, SendType config, Map<String, Properties> idPropertyMap) throws TaskExecutionException, BlackboardAccessException, RecordFilterNotFoundException {
        Connection connection = null;
        Session session = null;
        try {
            connection = env.getServices().getBrokerConnections().getConnection((QueueConnectionType)config, true);
            connection.start();
            session = connection.createSession(true, 1);
            Queue destination = session.createQueue(config.getQueue());
            MessageProducer producer = session.createProducer((Destination)destination);
            if (config.isPersistentDelivery()) {
                producer.setDeliveryMode(2);
            } else {
                producer.setDeliveryMode(1);
            }
            for (Map.Entry<String, Properties> entry : idPropertyMap.entrySet()) {
                Record record = this.createMessageRecord(entry.getKey(), config, env);
                producer.send(this.createMessage(config, record, entry.getValue(), session));
            }
            env.getBlackboard().commit();
            env.setCommitRequired(false);
            session.commit();
            String[] stringArray = idPropertyMap.keySet().toArray(new String[idPropertyMap.size()]);
            this.closeQuietly(session);
            this.closeQuietly(connection);
            return stringArray;
        }
        catch (Throwable e) {
            try {
                this._log.error((Object)this.msg("Error"), e);
                this.rollbackQuietly(session);
                throw new TaskExecutionException(e);
            }
            catch (Throwable throwable) {
                this.closeQuietly(session);
                this.closeQuietly(connection);
                throw throwable;
            }
        }
    }

    private Record createMessageRecord(String id, SendType config, TaskExecutionEnv env) throws BlackboardAccessException, RecordFilterNotFoundException {
        Record record = null;
        record = StringUtils.isNotEmpty((String)config.getRecordFilter()) ? env.getBlackboard().getRecord(id, config.getRecordFilter()) : env.getBlackboard().getRecord(id);
        if (config.isWithAttachments()) {
            this.glueAttachmentsBack(env, record);
        }
        return record;
    }

    private void glueAttachmentsBack(TaskExecutionEnv env, Record record) throws BlackboardAccessException {
        Blackboard blackboard = env.getBlackboard();
        Iterator attachmentNames = record.getAttachmentNames();
        while (attachmentNames.hasNext()) {
            String attachmentName = (String)attachmentNames.next();
            if (record.getAttachment(attachmentName) != null) continue;
            record.setAttachment(attachmentName, blackboard.getAttachment(record.getId(), attachmentName));
        }
    }

    private Message createMessage(SendType config, Record record, Properties messageProperties, Session session) throws JMSException {
        BytesMessage message = session.createBytesMessage();
        if (messageProperties != null) {
            Enumeration<?> propertyNames = messageProperties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String name = (String)propertyNames.nextElement();
                message.setStringProperty(name, messageProperties.getProperty(name));
            }
        }
        for (PropertyType property : config.getSetProperty()) {
            message.setStringProperty(property.getName(), property.getValue());
        }
        byte[] serialized = XmlSerializationUtils.serialize2byteArray((Record)record);
        message.writeBytes(serialized);
        return message;
    }

    private void closeQuietly(Connection connection) {
        if (connection != null) {
            try {
                connection.stop();
            }
            catch (Throwable e) {
                this._log.error((Object)"Unable to stop connection", e);
            }
            try {
                connection.close();
            }
            catch (Throwable e) {
                this._log.error((Object)"Unable to close connection", e);
            }
        }
    }

    private void rollbackQuietly(Session session) {
        if (session != null) {
            try {
                session.rollback();
            }
            catch (Throwable e1) {
                this._log.error((Object)"Unable to rollback session", e1);
            }
        }
    }

    private void closeQuietly(Session session) {
        if (session != null) {
            try {
                session.close();
            }
            catch (Throwable e1) {
                this._log.error((Object)"Unable to close session", e1);
            }
        }
    }
}

