/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.lucene.templates.transformer;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.eclipse.smila.search.lucene.index.IndexConnection;
import org.eclipse.smila.search.lucene.messages.advsearch.DDateField;
import org.eclipse.smila.search.lucene.messages.advsearch.DNumField;
import org.eclipse.smila.search.lucene.messages.advsearch.DOPN;
import org.eclipse.smila.search.lucene.messages.advsearch.DTerm;
import org.eclipse.smila.search.lucene.messages.advsearch.DTextField;
import org.eclipse.smila.search.lucene.messages.indexstructure.DIndexField;
import org.eclipse.smila.search.lucene.tools.search.lucene.DTextFieldParameter;
import org.eclipse.smila.search.templates.NodeTransformer;
import org.eclipse.smila.search.templates.NodeTransformerException;
import org.eclipse.smila.search.utils.advsearch.ITermContent;
import org.eclipse.smila.search.utils.search.DField;
import org.eclipse.smila.search.utils.search.DNumberField;

public class SimpleNodeTransformer
extends NodeTransformer {
    public ITermContent transformNode(DField dField) throws NodeTransformerException {
        if (dField instanceof org.eclipse.smila.search.utils.search.DTextField) {
            org.eclipse.smila.search.utils.search.DTextField dTextField = (org.eclipse.smila.search.utils.search.DTextField)dField;
            DTextFieldParameter tfp = (DTextFieldParameter)dTextField.getParameter();
            StringTokenizer st = new StringTokenizer(dTextField.getText().trim(), " ", false);
            DTextFieldParameter.DOperator operator = tfp.getOperator();
            DTextFieldParameter.DTolerance tolerance = tfp.getTolerance();
            boolean fuzzy = false;
            boolean parseWildcards = false;
            int slop = 0;
            if (tolerance == DTextFieldParameter.DTolerance.TOLERANT) {
                fuzzy = true;
                parseWildcards = true;
                IndexConnection ic = (IndexConnection)this.getIndexConnection();
                DIndexField indexField = (DIndexField)ic.getIndex().getIndexStructure().getField(dField.getFieldNo());
                if (indexField.getTokenize() && operator == DTextFieldParameter.DOperator.PHRASE) {
                    fuzzy = false;
                    parseWildcards = false;
                }
                TokenStream ts = ic.getAnalyzer().tokenStream(indexField.getName(), (Reader)new StringReader(dTextField.getText().trim()));
                try {
                    while (ts.next() != null) {
                        ++slop;
                    }
                }
                catch (IOException iOException) {}
                slop = (slop - 1) * 2;
            }
            if (st.countTokens() > 1 && operator != DTextFieldParameter.DOperator.PHRASE) {
                DTextField[] textFields = new DTextField[st.countTokens()];
                int i = 0;
                while (st.hasMoreTokens()) {
                    textFields[i] = new DTextField(dTextField.getFieldNo(), st.nextToken(), fuzzy, parseWildcards, slop);
                    ++i;
                }
                DOPN op = new DOPN();
                if (operator == DTextFieldParameter.DOperator.AND) {
                    op.setOperation("AND");
                } else if (operator == DTextFieldParameter.DOperator.OR) {
                    op.setOperation("OR");
                } else {
                    op.setOperation("WMEAN");
                }
                int i2 = 0;
                while (i2 < textFields.length) {
                    op.addTerm(new DTerm(textFields[i2]));
                    ++i2;
                }
                return op;
            }
            return new DTextField(dTextField.getFieldNo(), dTextField.getText(), fuzzy, parseWildcards, slop);
        }
        if (dField instanceof DNumberField) {
            DNumberField dNumberField = (DNumberField)dField;
            return new DNumField(dNumberField.getFieldNo(), dNumberField.getMin(), dNumberField.getMax());
        }
        if (dField instanceof org.eclipse.smila.search.utils.search.DDateField) {
            org.eclipse.smila.search.utils.search.DDateField dDateField = (org.eclipse.smila.search.utils.search.DDateField)dField;
            return new DDateField(dDateField.getFieldNo(), dDateField.getDateMin().getTime(), dDateField.getDateMax().getTime());
        }
        throw new NodeTransformerException("unknown node type [" + dField.getClass().getName() + "]");
    }
}

