/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.lucene.tools.search.lucene;

import org.eclipse.smila.search.lucene.tools.search.lucene.DTextFieldParameterCodec;
import org.eclipse.smila.search.utils.search.ITFParameter;

public final class DTextFieldParameter
implements ITFParameter {
    private DTolerance _tolerance;
    private DOperator _operator;

    public Object clone() {
        DTextFieldParameter tfp = new DTextFieldParameter();
        tfp.setOperator(this._operator);
        tfp.setTolerance(this._tolerance);
        return tfp;
    }

    public DOperator getOperator() {
        return this._operator;
    }

    public void setOperator(DOperator value) {
        this._operator = value;
    }

    public DTolerance getTolerance() {
        return this._tolerance;
    }

    public void setTolerance(DTolerance value) {
        this._tolerance = value;
    }

    public Class getCodecClass() {
        return DTextFieldParameterCodec.class;
    }

    public boolean isComplete() {
        if (this._tolerance == null) {
            return false;
        }
        return this._operator != null;
    }

    public static final class DOperator {
        public static final DOperator AND = new DOperator("AND");
        public static final DOperator OR = new DOperator("OR");
        public static final DOperator PHRASE = new DOperator("PHRASE");
        public String _mStrValue;

        private DOperator(String value) {
            this._mStrValue = value;
        }

        public static DOperator getInstance(String operator) {
            if ("AND".equals(operator)) {
                return AND;
            }
            if ("OR".equals(operator)) {
                return OR;
            }
            if ("PHRASE".equals(operator)) {
                return PHRASE;
            }
            return null;
        }

        public String toString() {
            return this._mStrValue;
        }
    }

    public static class DTolerance {
        public static final DTolerance TOLERANT = new DTolerance("tolerant");
        public static final DTolerance EXACT = new DTolerance("exact");
        public String _mStrValue;

        private DTolerance(String value) {
            this._mStrValue = value;
        }

        public static DTolerance getInstance(String tolerance) {
            if ("tolerant".equals(tolerance)) {
                return TOLERANT;
            }
            if ("exact".equals(tolerance)) {
                return EXACT;
            }
            return null;
        }

        public String toString() {
            return this._mStrValue;
        }
    }
}

