/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.utils.file;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.smila.utils.file.Exclude;
import org.eclipse.smila.utils.file.FileFilterUtils;
import org.eclipse.smila.utils.file.Include;

public class FileFilter
implements FilenameFilter {
    private final ArrayList<? extends Include> _includes;
    private final ArrayList<? extends Exclude> _excludes;
    private final boolean _caseSensitive;

    public FileFilter(ArrayList<? extends Include> includes, ArrayList<? extends Exclude> excludes, boolean caseSensitive) {
        this._includes = includes;
        this._excludes = excludes;
        this._caseSensitive = caseSensitive;
    }

    @Override
    public boolean accept(File pathname, String name) {
        boolean accept = false;
        File file = new File(String.valueOf(pathname.getPath()) + File.separatorChar + name);
        for (Include include : this._includes) {
            if (!FileFilterUtils.matchPath(include.getName(), file.getPath(), this._caseSensitive)) continue;
            Date dateFrom = include.getDateFrom();
            Date dateTo = include.getDateTo();
            if (dateFrom != null) {
                if (dateTo == null) {
                    dateTo = new Date();
                }
                if (file.lastModified() >= dateFrom.getTime() && file.lastModified() <= dateTo.getTime()) {
                    continue;
                }
            } else if (include.getPeriod() != null) {
                int interval = Integer.parseInt(include.getPeriod().substring(0, include.getPeriod().length() - 1));
                char measure = include.getPeriod().charAt(include.getPeriod().length() - 1);
                Date now = new Date();
                Date compareDate = (Date)now.clone();
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(compareDate);
                switch (measure) {
                    case 'Y': {
                        cal.add(1, -interval);
                        break;
                    }
                    case 'M': {
                        cal.add(2, -interval);
                        break;
                    }
                    case 'D': {
                        cal.add(5, -interval);
                        break;
                    }
                    case 'h': {
                        cal.add(10, -interval);
                        break;
                    }
                    case 'm': {
                        cal.add(12, -interval);
                        break;
                    }
                    case 's': {
                        cal.add(13, -interval);
                        break;
                    }
                }
                compareDate = cal.getTime();
                if (file.lastModified() < compareDate.getTime()) continue;
            }
            accept = true;
            break;
        }
        for (Exclude exclude : this._excludes) {
            if (!FileFilterUtils.matchPath(exclude.getName(), file.getAbsolutePath(), this._caseSensitive)) continue;
            accept = false;
            break;
        }
        return accept;
    }
}

