/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.utils.xml.stax;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.io.IOUtils;
import org.eclipse.smila.utils.xml.stax.MarkerTag;
import org.eclipse.smila.utils.xml.stax.XmlSnippetHandler;

public class XmlSnippetSplitter {
    private final XMLInputFactory _inputFactory = XMLInputFactory.newInstance();
    private final XMLOutputFactory _outputFactory = XMLOutputFactory.newInstance();
    private XmlSnippetHandler _snippetHandler;
    private MarkerTag _begin;
    private MarkerTag _end;

    public XmlSnippetSplitter(XmlSnippetHandler snippetHandlet, MarkerTag begin, MarkerTag end) {
        if (snippetHandlet == null) {
            throw new IllegalArgumentException("parameter snippetHandler is null");
        }
        if (begin == null) {
            throw new IllegalArgumentException("parameter begin is null");
        }
        if (end == null) {
            throw new IllegalArgumentException("parameter end is null");
        }
        this._snippetHandler = snippetHandlet;
        this._begin = begin;
        this._end = end;
    }

    public void read(InputStream inputStream) throws XMLStreamException {
        if (inputStream != null) {
            try {
                XMLEventReader eventReader = this._inputFactory.createXMLEventReader(inputStream);
                this.parse(eventReader);
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
    }

    private void parse(XMLEventReader eventReader) throws XMLStreamException {
        ByteArrayOutputStream outputStream = null;
        XMLEventWriter eventWriter = null;
        try {
            while (eventReader.hasNext()) {
                XMLEvent event = eventReader.nextEvent();
                if (this.isSnippetBegin(event)) {
                    outputStream = new ByteArrayOutputStream();
                    eventWriter = this._outputFactory.createXMLEventWriter(outputStream);
                    eventWriter.add(event);
                    continue;
                }
                if (this.isSnippetEnd(event)) {
                    if (eventWriter == null) continue;
                    eventWriter.add(event);
                    eventWriter.close();
                    this._snippetHandler.handleSnippet(outputStream.toByteArray());
                    eventWriter = null;
                    outputStream = null;
                    continue;
                }
                if (eventWriter == null) continue;
                eventWriter.add(event);
            }
        }
        finally {
            if (eventWriter != null) {
                eventWriter.close();
            }
        }
    }

    private boolean isSnippetBegin(XMLEvent event) {
        boolean condition = false;
        condition = this._begin.isEndTag() ? event.isEndElement() : event.isStartElement();
        return condition && this._begin.getName().equals(event.asStartElement().getName().getLocalPart());
    }

    private boolean isSnippetEnd(XMLEvent event) {
        boolean condition = false;
        condition = this._end.isEndTag() ? event.isEndElement() : event.isStartElement();
        return condition && this._end.getName().equals(event.asEndElement().getName().getLocalPart());
    }
}

