/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.ode.store.ProcessStoreImpl;
import org.apache.ode.utils.fs.FileUtils;

public class DeploymentBrowser {
    private ProcessStoreImpl _store;
    private AxisConfiguration _config;
    private File _appRoot;
    private static final String CSS = "body {\n    font: 75% Verdana, Helvetica, Arial, sans-serif;\n    background: White;\n    color: Black;\n    margin: 1em;\n    padding: 1em;\n}\n\nh1, h2, h3, h4, h5, h6 {\n    color: Black;\n    clear: left;\n    font: 100% Verdana, Helvetica, Arial, sans-serif;\n    margin: 0;\n    padding-left: 0.5em;\n} \n\nh1 {\n    font-size: 150%;\n    border-bottom: none;\n    text-align: right;\n    border-bottom: 1px solid Gray;\n}\n    \nh2 {\n    font-size: 130%;\n    border-bottom: 1px solid Gray;\n}\n\nh3 {\n    font-size: 120%;\n    padding-left: 1.0em;\n    border-bottom: 1px solid Gray;\n}\n\nh4 {\n    font-size: 110%;\n    padding-left: 1.5em;\n    border-bottom: 1px solid Gray;\n}\n\np {\n    text-align: justify;\n    line-height: 1.5em;\n    padding-left: 1.5em;\n}\n\na {\n    text-decoration: underline;\n    color: Black;\n}";

    public DeploymentBrowser(ProcessStoreImpl processStoreImpl, AxisConfiguration axisConfiguration, File file) {
        this._store = processStoreImpl;
        this._config = axisConfiguration;
        this._appRoot = file;
    }

    public boolean doFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        final String string = httpServletRequest.getRequestURI();
        int n = string.indexOf("/deployment");
        if (n > 0) {
            final String string2 = httpServletRequest.getScheme() + "://" + httpServletRequest.getServerName() + ":" + httpServletRequest.getServerPort() + string.substring(0, n);
            int n2 = string.length() > n + 11 ? 1 : 0;
            final String[] stringArray = string.substring(n + 11 + n2).split("/");
            if (stringArray.length == 0 || stringArray[0].length() == 0) {
                this.renderHtml(httpServletResponse, "ODE Deployment Browser", new DocBody(){

                    public void render(Writer writer) throws IOException {
                        writer.write("<p><a href=\"bundles/\">Deployed Bundles</a></p>");
                        writer.write("<p><a href=\"services/\">Process Services</a></p>");
                        writer.write("<p><a href=\"processes/\">Process Definitions</a></p>");
                    }
                });
            } else if (stringArray.length > 0) {
                if ("services".equals(stringArray[0])) {
                    if (stringArray.length == 1) {
                        this.renderHtml(httpServletResponse, "Services Implemented by Your Processes", new DocBody(){

                            public void render(Writer writer) throws IOException {
                                for (Object k : DeploymentBrowser.this._config.getServices().keySet()) {
                                    Object object;
                                    if ("Version".equals(k)) continue;
                                    AxisService axisService = DeploymentBrowser.this._config.getService(k.toString());
                                    String string = null;
                                    if ("DeploymentService".equals(axisService.getName()) || "InstanceManagement".equals(axisService.getName()) || "ProcessManagement".equals(axisService.getName())) {
                                        string = axisService.getName();
                                    } else if (axisService.getFileName() != null) {
                                        object = DeploymentBrowser.this.bundleUrlFor(axisService.getFileName().getFile());
                                        string = object != null ? string2 + (String)object : string2 + "/services/" + axisService.getName() + "?wsdl";
                                    }
                                    writer.write("<p><a href=\"" + string + "\">" + k + "</a></p>");
                                    writer.write("<ul><li>Endpoint: " + string2 + "/processes/" + k + "</li>");
                                    object = axisService.getOperations();
                                    ArrayList<String> arrayList = new ArrayList<String>();
                                    while (object.hasNext()) {
                                        arrayList.add(((AxisOperation)object.next()).getName().getLocalPart());
                                    }
                                    writer.write("<li>Operations: " + StringUtils.join(arrayList.iterator(), (String)", ") + "</li></ul>");
                                }
                            }
                        });
                    } else {
                        final String string3 = string.substring(n + 12 + 9);
                        final AxisService axisService = this._config.getService(string3);
                        if (axisService != null) {
                            this.renderXml(httpServletResponse, new DocBody(){

                                public void render(Writer writer) throws IOException {
                                    if ("InstanceManagement".equals(string3) || "ProcessManagement".equals(string3)) {
                                        DeploymentBrowser.this.write(writer, new File(DeploymentBrowser.this._appRoot, "pmapi.wsdl").getPath());
                                    } else if (string.indexOf("pmapi.xsd") > 0) {
                                        DeploymentBrowser.this.write(writer, new File(DeploymentBrowser.this._appRoot, "pmapi.xsd").getPath());
                                    } else if ("DeploymentService".equals(string3)) {
                                        DeploymentBrowser.this.write(writer, new File(DeploymentBrowser.this._appRoot, "deploy.wsdl").getPath());
                                    } else {
                                        DeploymentBrowser.this.write(writer, axisService.getFileName().getFile());
                                    }
                                }
                            });
                        } else {
                            this.renderHtml(httpServletResponse, "Service Not Found", new DocBody(){

                                public void render(Writer writer) throws IOException {
                                    writer.write("<p>Couldn't find service " + string3 + "</p>");
                                }
                            });
                        }
                    }
                } else if ("processes".equals(stringArray[0])) {
                    if (stringArray.length == 1) {
                        this.renderHtml(httpServletResponse, "Deployed Processes", new DocBody(){

                            public void render(Writer writer) throws IOException {
                                for (QName qName : DeploymentBrowser.this._store.getProcesses()) {
                                    String string = string2 + DeploymentBrowser.this.bundleUrlFor(DeploymentBrowser.this._store.getProcessConfiguration(qName).getBpelDocument());
                                    String[] stringArray = qName.getLocalPart().split("-");
                                    writer.write("<p><a href=\"" + string + "\">" + stringArray[0] + "</a> (v" + stringArray[1] + ")");
                                    writer.write(" - " + qName.getNamespaceURI() + "</p>");
                                }
                            }
                        });
                    }
                } else if ("bundles".equals(stringArray[0])) {
                    if (stringArray.length == 1) {
                        this.renderHtml(httpServletResponse, "Deployment Bundles", new DocBody(){

                            public void render(Writer writer) throws IOException {
                                for (String string : DeploymentBrowser.this._store.getPackages()) {
                                    writer.write("<p><a href=\"" + string + "\">" + string + "</a></p>");
                                }
                            }
                        });
                    } else if (stringArray.length == 2) {
                        this.renderHtml(httpServletResponse, "Files in Bundle " + stringArray[1], new DocBody(){

                            public void render(Writer writer) throws IOException {
                                List list = DeploymentBrowser.this._store.listProcesses(stringArray[1]);
                                if (list != null) {
                                    List list2 = DeploymentBrowser.this._store.getProcessConfiguration((QName)list.get(0)).getFiles();
                                    for (File file : list2) {
                                        String string = file.getPath().substring(file.getPath().indexOf("processes") + 10).replaceAll("\\\\", "/");
                                        writer.write("<p><a href=\"" + string + "\">" + string + "</a></p>");
                                    }
                                } else {
                                    writer.write("<p>Couldn't find bundle " + stringArray[2] + "</p>");
                                }
                            }
                        });
                    } else if (stringArray.length > 2) {
                        List list = this._store.listProcesses(stringArray[1]);
                        if (list != null) {
                            List list2 = this._store.getProcessConfiguration((QName)list.get(0)).getFiles();
                            for (final File file : list2) {
                                String string4 = string.substring(n + 12 + 9 + stringArray[1].length());
                                if (!file.getPath().endsWith(string4)) continue;
                                this.renderXml(httpServletResponse, new DocBody(){

                                    public void render(Writer writer) throws IOException {
                                        DeploymentBrowser.this.write(writer, file.getPath());
                                    }
                                });
                                return true;
                            }
                        } else {
                            this.renderHtml(httpServletResponse, "No Bundle Found", new DocBody(){

                                public void render(Writer writer) throws IOException {
                                    writer.write("<p>Couldn't find bundle " + stringArray[2] + "</p>");
                                }
                            });
                        }
                    }
                } else if ("getBundleDocs".equals(stringArray[0])) {
                    String string5;
                    List list;
                    if (stringArray.length == 1) {
                        this.renderXml(httpServletResponse, new DocBody(){

                            public void render(Writer writer) throws IOException {
                                writer.write("<getBundleDocsResponse>");
                                writer.write("<error>Not enough args..</error>");
                                writer.write("</getBundleDocsResponse>");
                            }
                        });
                    } else if (stringArray.length == 2 && (list = this._store.listProcesses(string5 = stringArray[1])) != null) {
                        this.renderXml(httpServletResponse, new DocBody(){

                            public void render(Writer writer) throws IOException {
                                writer.write("<getBundleDocsResponse><name>" + string5 + "</name>");
                                for (QName qName : list) {
                                    List list2 = DeploymentBrowser.this._store.getProcessConfiguration(qName).getFiles();
                                    String string = DeploymentBrowser.this._store.getProcessConfiguration(qName).getProcessId().toString();
                                    writer.write("<process><pid>" + string + "</pid>");
                                    for (File file : list2) {
                                        String string2;
                                        if (file.getPath().endsWith(".wsdl")) {
                                            string2 = file.getPath().substring(DeploymentBrowser.this._store.getDeployDir().getCanonicalPath().length() + 1);
                                            writer.write("<wsdl>" + string2 + "</wsdl>");
                                        }
                                        if (!file.getPath().endsWith(".bpel")) continue;
                                        string2 = file.getPath().substring(DeploymentBrowser.this._store.getDeployDir().getCanonicalPath().length() + 1);
                                        writer.write("<bpel>" + string2 + "</bpel>");
                                    }
                                    writer.write("</process>");
                                }
                                writer.write("</getBundleDocsResponse>");
                            }
                        });
                    }
                } else if ("getProcessDefinition".equals(stringArray[0])) {
                    if (stringArray.length == 1) {
                        this.renderXml(httpServletResponse, new DocBody(){

                            public void render(Writer writer) throws IOException {
                                writer.write("<getProcessDefinitionResponse>");
                                writer.write("<error>Not enough args..</error>");
                                writer.write("</getProcessDefinitionResponse>");
                            }
                        });
                    } else if (stringArray.length == 2) {
                        String string6 = stringArray[1];
                        for (QName qName : this._store.getProcesses()) {
                            String[] stringArray2 = qName.getLocalPart().split("-");
                            if (!string6.equals(stringArray2[0])) continue;
                            final String string7 = string2 + this.bundleUrlFor(this._store.getProcessConfiguration(qName).getBpelDocument());
                            this.renderXml(httpServletResponse, new DocBody(){

                                public void render(Writer writer) throws IOException {
                                    writer.write("<getProcessDefinition>");
                                    writer.write("<url>" + string7 + "</url>");
                                    writer.write("</getProcessDefinition>");
                                }
                            });
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    private void renderHtml(HttpServletResponse httpServletResponse, String string, DocBody docBody) throws IOException {
        httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = httpServletResponse.getWriter();
        ((Writer)printWriter).write("<html><header><style type=\"text/css\">body {\n    font: 75% Verdana, Helvetica, Arial, sans-serif;\n    background: White;\n    color: Black;\n    margin: 1em;\n    padding: 1em;\n}\n\nh1, h2, h3, h4, h5, h6 {\n    color: Black;\n    clear: left;\n    font: 100% Verdana, Helvetica, Arial, sans-serif;\n    margin: 0;\n    padding-left: 0.5em;\n} \n\nh1 {\n    font-size: 150%;\n    border-bottom: none;\n    text-align: right;\n    border-bottom: 1px solid Gray;\n}\n    \nh2 {\n    font-size: 130%;\n    border-bottom: 1px solid Gray;\n}\n\nh3 {\n    font-size: 120%;\n    padding-left: 1.0em;\n    border-bottom: 1px solid Gray;\n}\n\nh4 {\n    font-size: 110%;\n    padding-left: 1.5em;\n    border-bottom: 1px solid Gray;\n}\n\np {\n    text-align: justify;\n    line-height: 1.5em;\n    padding-left: 1.5em;\n}\n\na {\n    text-decoration: underline;\n    color: Black;\n}</style></header><body>\n");
        ((Writer)printWriter).write("<h2>" + string + "</h2><p/>\n");
        docBody.render(printWriter);
        ((Writer)printWriter).write("</body></html>");
    }

    private void renderXml(HttpServletResponse httpServletResponse, DocBody docBody) throws IOException {
        httpServletResponse.setContentType("text/xml");
        httpServletResponse.setCharacterEncoding("UTF-8");
        PrintWriter printWriter = httpServletResponse.getWriter();
        docBody.render(printWriter);
    }

    private void write(Writer writer, String string) throws IOException {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        while ((string2 = bufferedReader.readLine()) != null) {
            writer.write(string2 + "\n");
        }
        bufferedReader.close();
    }

    private String bundleUrlFor(String string) {
        if (string.indexOf("processes") >= 0) {
            string = string.substring(string.indexOf("processes") + 10);
        }
        ArrayList arrayList = FileUtils.listFilesRecursively((File)this._store.getDeployDir(), null);
        for (File file : arrayList) {
            if (!file.getPath().replaceAll("\\\\", "/").endsWith(string)) continue;
            return "/deployment/bundles/" + file.getPath().substring(this._store.getDeployDir().getPath().length() + 1).replaceAll("\\\\", "/");
        }
        return null;
    }

    static interface DocBody {
        public void render(Writer var1) throws IOException;
    }
}

