/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.highlighting.transformer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import org.eclipse.smila.search.highlighting.transformer.HighlightingTransformer;
import org.eclipse.smila.search.highlighting.transformer.HighlightingTransformerException;
import org.eclipse.smila.search.utils.param.ParameterSet;
import org.eclipse.smila.search.utils.searchresult.DHighLighted;

public class ComplexHLResultAggregation
extends HighlightingTransformer {
    @Override
    public ArrayList<Object> transform(ArrayList<Object> data, ParameterSet parameterSet) throws HighlightingTransformerException {
        int maxElements;
        int i;
        if (data == null) {
            throw new NullPointerException("data");
        }
        int maxPrecedingChars = parameterSet.getIntegerParameter("MaxPrecedingCharacters");
        int maxSucceedingChars = parameterSet.getIntegerParameter("MaxSucceedingCharacters");
        SortAlgorithm sortAlgorithm = SortAlgorithm.valueOf(parameterSet.getStringParameter("SortAlgorithm"));
        Integer maxHLElements = parameterSet.getIntegerParameter("MaxHLElements");
        Integer maxLength = parameterSet.getIntegerParameter("MaxLength");
        TextHandling textHandling = TextHandling.valueOf(parameterSet.getStringParameter("TextHandling"));
        String precedingCharacters = parameterSet.getStringParameter("PrecedingCharacters");
        String succeedingCharacters = parameterSet.getStringParameter("SucceedingCharacters");
        boolean elFilter = parameterSet.getBooleanParameter("HLElementFilter");
        ArrayList<HlTriple> hlTriples = new ArrayList<HlTriple>();
        StringBuffer prefix = new StringBuffer();
        StringBuffer suffix = new StringBuffer();
        int i2 = 0;
        while (i2 < data.size()) {
            HlTriple hlTriple = new HlTriple();
            while (!(data.get(i2) instanceof DHighLighted)) {
                prefix = prefix.append((String)data.get(i2));
                if (i2 >= data.size() - 1) break;
                ++i2;
            }
            hlTriple._prefix = prefix.toString();
            prefix = new StringBuffer();
            if (data.get(i2) instanceof DHighLighted) {
                hlTriple._highLighted = (DHighLighted)data.get(i2);
                if (i2 < data.size()) {
                    ++i2;
                }
            }
            if (i2 < data.size()) {
                while (!(data.get(i2) instanceof DHighLighted)) {
                    suffix = suffix.append((String)data.get(i2));
                    if (i2 >= data.size() - 1) break;
                    ++i2;
                }
            }
            hlTriple._suffix = suffix.toString();
            suffix = new StringBuffer();
            hlTriples.add(hlTriple);
            prefix = prefix.append(hlTriple._suffix);
            if (i2 != data.size() - 1) continue;
            ++i2;
        }
        Object[] hlTriplesArray = new HlTriple[]{};
        hlTriplesArray = hlTriples.toArray(hlTriplesArray);
        if (sortAlgorithm == SortAlgorithm.Score) {
            Arrays.sort(hlTriplesArray);
        }
        if (elFilter) {
            Hashtable<String, Object> elements = new Hashtable<String, Object>();
            ArrayList<Object> newElements = new ArrayList<Object>();
            i = 0;
            while (i < hlTriplesArray.length) {
                if (((HlTriple)hlTriplesArray[i])._highLighted == null) {
                    newElements.add(hlTriplesArray[i]);
                } else if (!elements.containsKey(((HlTriple)hlTriplesArray[i])._highLighted.getText())) {
                    elements.put(((HlTriple)hlTriplesArray[i])._highLighted.getText(), hlTriplesArray[i]);
                    newElements.add(hlTriplesArray[i]);
                }
                ++i;
            }
            hlTriplesArray = new HlTriple[newElements.size()];
            hlTriplesArray = (HlTriple[])newElements.toArray(hlTriplesArray);
        }
        if (maxHLElements != null && hlTriplesArray.length > (maxElements = maxHLElements.intValue())) {
            HlTriple[] temp = new HlTriple[maxElements];
            i = 0;
            while (i < maxElements) {
                temp[i] = hlTriplesArray[i];
                ++i;
            }
            hlTriplesArray = temp;
        }
        ArrayList<Object> newData = new ArrayList<Object>();
        int charCount = 0;
        if (hlTriplesArray.length == 1 && ((HlTriple)hlTriplesArray[0])._highLighted == null && textHandling == TextHandling.ReturnFullText) {
            String s = (String)data.get(0);
            int length = s.length() < maxLength ? s.length() : maxLength.intValue();
            String hlExtract = s.substring(0, length);
            if (s.length() > maxLength) {
                hlExtract = String.valueOf(hlExtract) + succeedingCharacters;
            }
            newData.add(hlExtract);
        } else if (hlTriplesArray.length != 1 || ((HlTriple)hlTriplesArray[0])._highLighted != null || textHandling != TextHandling.ReturnNoText) {
            i = 0;
            while (i < hlTriplesArray.length) {
                String s;
                if (((HlTriple)hlTriplesArray[i])._prefix != null) {
                    s = ((HlTriple)hlTriplesArray[i])._prefix.length() <= maxPrecedingChars ? ((HlTriple)hlTriplesArray[i])._prefix : ((HlTriple)hlTriplesArray[i])._prefix.substring(((HlTriple)hlTriplesArray[i])._prefix.length() - maxPrecedingChars);
                    charCount += s.length();
                    if (!"".equals(s) && !" ".equals(s) && precedingCharacters != null) {
                        s = String.valueOf(precedingCharacters) + s;
                    }
                    ((HlTriple)hlTriplesArray[i])._prefix = s;
                    newData.add(s);
                }
                if (((HlTriple)hlTriplesArray[i])._highLighted != null) {
                    charCount += ((HlTriple)hlTriplesArray[i])._highLighted.getText().length();
                    newData.add(((HlTriple)hlTriplesArray[i])._highLighted);
                }
                if (((HlTriple)hlTriplesArray[i])._suffix != null) {
                    s = ((HlTriple)hlTriplesArray[i])._suffix.length() <= maxSucceedingChars ? ((HlTriple)hlTriplesArray[i])._suffix : ((HlTriple)hlTriplesArray[i])._suffix.substring(0, maxSucceedingChars);
                    charCount += s.length();
                    if (!"".equals(s) && !" ".equals(s) && succeedingCharacters != null) {
                        s = String.valueOf(s) + succeedingCharacters;
                    }
                    ((HlTriple)hlTriplesArray[i])._suffix = s;
                    newData.add(s);
                }
                if (maxLength != null && charCount >= maxLength) break;
                ++i;
            }
        }
        return newData;
    }

    public static class HlTriple
    implements Comparable<HlTriple> {
        private String _prefix;
        private DHighLighted _highLighted;
        private String _suffix;

        @Override
        public int compareTo(HlTriple obj) {
            if (obj == null) {
                throw new NullPointerException();
            }
            if (this._highLighted == null && obj._highLighted == null) {
                return 0;
            }
            if (this._highLighted == null && obj._highLighted != null) {
                return 1;
            }
            if (this._highLighted != null && obj._highLighted == null) {
                return -1;
            }
            if (this._highLighted.getScore() > obj._highLighted.getScore()) {
                return -1;
            }
            if (this._highLighted.getScore() < obj._highLighted.getScore()) {
                return 1;
            }
            return 0;
        }

        public DHighLighted getHighLighted() {
            return this._highLighted;
        }

        public String getPrefix() {
            return this._prefix;
        }

        public String getSuffix() {
            return this._suffix;
        }

        public void setHighLighted(DHighLighted highLighted) {
            this._highLighted = highLighted;
        }

        public void setPrefix(String prefix) {
            this._prefix = prefix;
        }

        public void setSuffix(String suffix) {
            this._suffix = suffix;
        }
    }

    public static enum SortAlgorithm {
        Occurrence,
        Score;

    }

    public static enum TextHandling {
        ReturnFullText,
        ReturnNoText,
        ReturnSnipplet;

    }
}

