/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.security.processing;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.security.SecurityAttribute;
import org.eclipse.smila.security.SecurityAttributes;
import org.eclipse.smila.security.SecurityException;
import org.eclipse.smila.security.SecurityResolver;
import org.eclipse.smila.utils.service.ServiceUtils;

public class SampleSecurityConverterPipelet
implements Pipelet {
    public static final String PROP_READ_USERS_ATTRIBUTE_NAME = "readUsersAttributeName";
    public static final String PROP_RESOLVE_GROUPS = "resolveGroups";
    public static final String PROP_RESOLVE_USER_NAMES = "resolveUserNames";
    public static final String PROP_RESOLVED_USER_NAME_PROPERTY_NAME = "resolvedUserNamePropertyName";
    public static final String EXECUTION_MODE = "_executionMode";
    private final Log _log = LogFactory.getLog(SampleSecurityConverterPipelet.class);
    private AnyMap _configuration;
    private String _readUsersAttributeName;
    private boolean _resolveGroups;
    private boolean _resolveUserNames;
    private String _resolvedUserNameProperty;
    private SecurityResolver _securityResolver;

    public void configure(AnyMap configuration) throws ProcessingException {
        this._configuration = configuration;
        if (this._configuration != null) {
            this._readUsersAttributeName = this._configuration.getStringValue(PROP_READ_USERS_ATTRIBUTE_NAME);
            this._resolveGroups = this._configuration.getBooleanValue(PROP_RESOLVE_GROUPS) != null;
            this._resolveUserNames = this._configuration.getBooleanValue(PROP_RESOLVE_USER_NAMES) != null;
            this._resolvedUserNameProperty = this._configuration.getStringValue(PROP_RESOLVED_USER_NAME_PROPERTY_NAME);
        } else {
            this._readUsersAttributeName = null;
            this._resolveGroups = false;
            this._resolvedUserNameProperty = null;
            this._resolveUserNames = false;
        }
    }

    public String[] process(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        int i = 0;
        while (i < recordIds.length) {
            block8: {
                try {
                    String executionModeValue = blackboard.getMetadata(recordIds[i]).getStringValue(EXECUTION_MODE);
                    if (executionModeValue != null) {
                        ExecutionMode executionMode = ExecutionMode.valueOf(executionModeValue);
                        switch (executionMode) {
                            case INDEX: {
                                this.convertToAttributes(blackboard, recordIds[i]);
                                break;
                            }
                            case SEARCH: {
                                this.convertToFilter(blackboard, recordIds[i]);
                                break;
                            }
                            default: {
                                break;
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    if (!this._log.isErrorEnabled()) break block8;
                    this._log.error((Object)("error processing record " + recordIds[i]), (Throwable)ex);
                }
            }
            ++i;
        }
        return recordIds;
    }

    private synchronized SecurityResolver getSecurityResolver() {
        block3: {
            if (this._securityResolver == null) {
                try {
                    this._securityResolver = (SecurityResolver)ServiceUtils.getService(SecurityResolver.class);
                }
                catch (InterruptedException interruptedException) {
                    if (!this._log.isWarnEnabled()) break block3;
                    this._log.warn((Object)"Interrupted while getting SecurityResolver service.");
                }
            }
        }
        return this._securityResolver;
    }

    private void convertToAttributes(Blackboard blackboard, String id) throws BlackboardAccessException, SecurityException {
        SecurityAttribute sa = new SecurityAttribute(blackboard.getRecord(id));
        Set<String> readAccessRights = this.getReadAccessRights(sa);
        if (!readAccessRights.isEmpty()) {
            AnySeq values = blackboard.getDataFactory().createAnySeq();
            for (String value : readAccessRights) {
                values.add(value);
            }
            blackboard.getMetadata(id).put((Object)this._readUsersAttributeName, (Object)values);
        }
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("converted security information for id " + id + " into attribute values"));
        }
    }

    private void convertToFilter(Blackboard blackboard, String id) throws BlackboardAccessException, SecurityException {
        SecurityAttribute sa = new SecurityAttribute(blackboard.getRecord(id));
        Set<String> readAccessRights = this.getReadAccessRights(sa);
        if (!readAccessRights.isEmpty()) {
            AnySeq filterSection = (AnySeq)blackboard.getRecord(id).getMetadata().get((Object)"filter");
            if (filterSection == null) {
                filterSection = blackboard.getDataFactory().createAnySeq();
                blackboard.getRecord(id).getMetadata().put((Object)"filter", (Object)filterSection);
            }
            AnyMap filterSectionForAttribute = null;
            for (Any filterSectionEntry : filterSection) {
                if (!this._readUsersAttributeName.equals(((AnyMap)filterSectionEntry).getStringValue("attribute"))) continue;
                filterSectionForAttribute = (AnyMap)filterSectionEntry;
            }
            if (filterSectionForAttribute == null) {
                filterSectionForAttribute = blackboard.getDataFactory().createAnyMap();
                filterSectionForAttribute.put("attribute", this._readUsersAttributeName);
                filterSection.add((Object)filterSectionForAttribute);
            }
            AnySeq oneOfFilter = blackboard.getDataFactory().createAnySeq();
            for (String value : readAccessRights) {
                oneOfFilter.add(value);
            }
            filterSectionForAttribute.put((Object)"oneOf", (Object)oneOfFilter);
            if (!blackboard.getMetadata(id).containsKey((Object)this._readUsersAttributeName)) {
                blackboard.getMetadata(id).put(this._readUsersAttributeName, "dummy");
            }
        }
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("converted security information for id " + id + " into query filter"));
        }
    }

    private Set<String> getReadAccessRights(SecurityAttribute sa) throws BlackboardAccessException, SecurityException {
        HashSet<String> accessRights = new HashSet<String>();
        AnySeq users = sa.getAccessRights(SecurityAttributes.AccessRightType.READ, SecurityAttributes.EntityType.PRINCIPALS);
        SecurityResolver securityResolver = this.getSecurityResolver();
        if (securityResolver != null) {
            HashSet<String> displayNames;
            AnySeq groups;
            if (users != null) {
                for (Any user : users) {
                    String userDN = securityResolver.resolvePrincipal(((Value)user).asString());
                    accessRights.add(userDN);
                }
            }
            if (this._resolveGroups && (groups = sa.getAccessRights(SecurityAttributes.AccessRightType.READ, SecurityAttributes.EntityType.GROUPS)) != null) {
                for (Any group : groups) {
                    String groupDN = securityResolver.resolvePrincipal(((Value)group).asString());
                    Set groupMembers = securityResolver.resolveGroupMembers(groupDN);
                    accessRights.addAll(groupMembers);
                }
            }
            if (this._resolveUserNames) {
                displayNames = new HashSet();
                for (String principalDN : accessRights) {
                    Map properties = securityResolver.getProperties(principalDN);
                    Collection resolvedUserNames = (Collection)properties.get(this._resolvedUserNameProperty);
                    if (resolvedUserNames == null || resolvedUserNames.isEmpty()) continue;
                    displayNames.add((String)resolvedUserNames.iterator().next());
                }
            } else {
                displayNames = accessRights;
            }
            return displayNames;
        }
        if (users != null) {
            for (Any user : users) {
                accessRights.add(((Value)user).asString());
            }
        }
        return accessRights;
    }

    public static enum ExecutionMode {
        INDEX,
        SEARCH;

    }
}

