/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.ode.bpel.engine.ODEProcess;
import org.apache.ode.bpel.engine.UnreliableMyRoleMessageExchangeImpl;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrokeredUnreliableMyRoleMessageExchangeImpl
extends UnreliableMyRoleMessageExchangeImpl {
    private List<MyRoleMessageExchange> subscribers;
    private MyRoleMessageExchange template;

    public BrokeredUnreliableMyRoleMessageExchangeImpl(ODEProcess oDEProcess, List<MyRoleMessageExchange> list, String string, MyRoleMessageExchange myRoleMessageExchange) {
        super(oDEProcess, string, null, myRoleMessageExchange.getOperation(), myRoleMessageExchange.getServiceName());
        this.subscribers = list;
        this.template = myRoleMessageExchange;
    }

    @Override
    public Future<MessageExchange.Status> invokeAsync() {
        for (MyRoleMessageExchange myRoleMessageExchange : this.subscribers) {
            myRoleMessageExchange.invokeAsync();
        }
        return new CompletedFuture();
    }

    @Override
    public MessageExchange.Status invokeBlocking() throws BpelEngineException, TimeoutException {
        for (MyRoleMessageExchange myRoleMessageExchange : this.subscribers) {
            myRoleMessageExchange.invokeBlocking();
        }
        return MessageExchange.Status.COMPLETED;
    }

    @Override
    public MessageExchange.AckType getAckType() {
        return this.template.getAckType();
    }

    @Override
    public EndpointReference getEndpointReference() throws BpelEngineException {
        return this.template.getEndpointReference();
    }

    @Override
    public Message getResponse() {
        return this.template.getResponse();
    }

    @Override
    public void setRequest(Message message) {
        for (MyRoleMessageExchange myRoleMessageExchange : this.subscribers) {
            myRoleMessageExchange.setRequest(this.cloneMessage(message));
        }
    }

    @Override
    public void setTimeout(long l) {
        for (MyRoleMessageExchange myRoleMessageExchange : this.subscribers) {
            myRoleMessageExchange.setTimeout(l);
        }
    }

    @Override
    public MessageExchange.Status getStatus() {
        return this.template.getStatus();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompletedFuture
    implements Future<MessageExchange.Status> {
        private CompletedFuture() {
        }

        @Override
        public boolean cancel(boolean bl) {
            return false;
        }

        @Override
        public MessageExchange.Status get() throws InterruptedException, ExecutionException {
            return MessageExchange.Status.COMPLETED;
        }

        @Override
        public MessageExchange.Status get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            return MessageExchange.Status.COMPLETED;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }
    }
}

