/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel;

import java.util.ArrayList;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.InvalidValueTypeException;

public final class MetadataUtils {
    private static final Log _log = LogFactory.getLog(MetadataUtils.class);

    static AnyMap getMap(Any metadata, CreateFlag createFlag, String ... path) {
        ArrayList<String> pathElements = new ArrayList<String>(16);
        String[] stringArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            String pathSegment = stringArray[n2];
            Object[] split = StringUtils.split((String)pathSegment, (char)'/');
            CollectionUtils.addAll(pathElements, (Object[])split);
            ++n2;
        }
        Any any = MetadataUtils.getAny(metadata, createFlag, pathElements, 0);
        return any == null ? null : any.asMap();
    }

    public static AnyMap getMap(AnyMap metadata, boolean createAll, String ... path) {
        return MetadataUtils.getMap((Any)metadata, createAll ? CreateFlag.ALL : CreateFlag.NONE, path);
    }

    private static boolean flags2bool(CreateFlag createFlag) {
        boolean create;
        switch (createFlag) {
            case NONE: {
                create = false;
                break;
            }
            case ALL: {
                create = true;
                break;
            }
            default: {
                throw new NotImplementedException("unknown create flag: " + (Object)((Object)createFlag));
            }
        }
        return create;
    }

    private static Any getAny(Any parent, CreateFlag createFlag, ArrayList<String> pathElements, int index) {
        Any child;
        if (index >= pathElements.size() || parent == null) {
            return parent;
        }
        String keyOrIndex = pathElements.get(index);
        boolean create = MetadataUtils.flags2bool(createFlag);
        if (parent.isMap()) {
            child = parent.asMap().getMap(keyOrIndex, create);
        } else if (parent.isSeq()) {
            child = (Any)parent.asSeq().get(Integer.parseInt(keyOrIndex));
        } else {
            String subPath = MetadataUtils.getSubPath(pathElements, index);
            throw new InvalidValueTypeException("expected Any to be one of SEQ or MAP at: " + subPath);
        }
        if (child == null && _log.isTraceEnabled()) {
            _log.trace((Object)("missing element: " + MetadataUtils.getSubPath(pathElements, index)));
        }
        return MetadataUtils.getAny(child, createFlag, pathElements, ++index);
    }

    private static String getSubPath(ArrayList<String> pathElements, int index) {
        return StringUtils.join(pathElements.subList(0, index), (char)'/');
    }

    private MetadataUtils() {
    }

    public static enum CreateFlag {
        PARENTS,
        ALL,
        NONE;

    }
}

