/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.xml;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DOMRecordWriter {
    private final boolean _printPretty;

    public DOMRecordWriter() {
        this(false);
    }

    public DOMRecordWriter(boolean printPretty) {
        this._printPretty = printPretty;
    }

    public Element appendRecord(Element parent, Record record) {
        Document factory = parent.getOwnerDocument();
        this.newline(factory, parent);
        Element recordElement = this.buildRecord(factory, record);
        recordElement.setAttribute("xmlns", "http://www.eclipse.org/smila/record");
        parent.appendChild(recordElement);
        this.newline(factory, parent);
        return recordElement;
    }

    public Element appendRecordList(Element parent, Iterable<Record> records) {
        Document factory = parent.getOwnerDocument();
        this.newline(factory, parent);
        Element recordListElement = this.appendElement(factory, parent, "RecordList");
        for (Record record : records) {
            Element recordElement = this.buildRecord(factory, record);
            recordListElement.appendChild(recordElement);
            this.newline(factory, parent);
        }
        return recordListElement;
    }

    public Element appendRecordList(Element parent, Record[] records) {
        Document factory = parent.getOwnerDocument();
        this.newline(factory, parent);
        Element recordListElement = this.appendElement(factory, parent, "RecordList");
        Record[] recordArray = records;
        int n = records.length;
        int n2 = 0;
        while (n2 < n) {
            Record record = recordArray[n2];
            Element recordElement = this.buildRecord(factory, record);
            recordListElement.appendChild(recordElement);
            this.newline(factory, parent);
            ++n2;
        }
        return recordListElement;
    }

    public Element buildRecord(Document factory, Record record) {
        Element recordElement = factory.createElementNS("http://www.eclipse.org/smila/record", "Record");
        recordElement.setAttribute("version", "2.0");
        this.newline(factory, recordElement);
        if (record.getMetadata() != null) {
            Set entries = record.getMetadata().entrySet();
            for (Map.Entry entry : entries) {
                if (((Any)entry.getValue()).isMap()) {
                    this.appendMap(factory, recordElement, (AnyMap)entry.getValue(), (String)entry.getKey());
                    continue;
                }
                if (((Any)entry.getValue()).isSeq()) {
                    this.appendSeq(factory, recordElement, (AnySeq)entry.getValue(), (String)entry.getKey());
                    continue;
                }
                this.appendVal(factory, recordElement, (Value)entry.getValue(), (String)entry.getKey());
            }
        }
        if (record.hasAttachments()) {
            Iterator<String> attachmentNames = record.getAttachmentNames();
            while (attachmentNames.hasNext()) {
                String attachmentName = attachmentNames.next();
                this.appendTextElement(factory, recordElement, "Attachment", attachmentName);
            }
        }
        return recordElement;
    }

    public void buildRecordAsDocumentElement(Document factory, Record record) {
        Element recordElement = this.buildRecord(factory, record);
        recordElement.setAttribute("version", "2.0");
        recordElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.eclipse.org/smila/record");
        factory.appendChild(recordElement);
    }

    private void appendMap(Document factory, Element parentElement, AnyMap anyMap, String key) {
        Element attributeElement = this.appendElement(factory, parentElement, "Map");
        if (key != null) {
            attributeElement.setAttribute("key", key);
        }
        if (!anyMap.isEmpty()) {
            for (String childKey : anyMap.keySet()) {
                Any any = (Any)anyMap.get(childKey);
                if (any.isMap()) {
                    this.appendMap(factory, attributeElement, (AnyMap)any, childKey);
                    continue;
                }
                if (any.isSeq()) {
                    this.appendSeq(factory, attributeElement, (AnySeq)any, childKey);
                    continue;
                }
                this.appendVal(factory, attributeElement, (Value)any, childKey);
            }
        }
    }

    private void appendSeq(Document factory, Element parentElement, AnySeq anySeq, String key) {
        Element attributeElement = this.appendElement(factory, parentElement, "Seq");
        if (key != null) {
            attributeElement.setAttribute("key", key);
        }
        if (!anySeq.isEmpty()) {
            for (Any any : anySeq) {
                if (any.isMap()) {
                    this.appendMap(factory, attributeElement, (AnyMap)any, null);
                    continue;
                }
                if (any.isSeq()) {
                    this.appendSeq(factory, attributeElement, (AnySeq)any, null);
                    continue;
                }
                this.appendVal(factory, attributeElement, (Value)any, null);
            }
        }
    }

    private void appendVal(Document factory, Element parentElement, Value value, String key) {
        Element valueElement = this.appendTextElement(factory, parentElement, "Val", value.asString());
        if (key != null) {
            valueElement.setAttribute("key", key);
        }
        if (value.getValueType() != Any.ValueType.STRING) {
            valueElement.setAttribute("type", value.getValueType().name().toLowerCase());
        }
    }

    private Element appendElement(Document factory, Element parentElement, String tag) {
        Element element = factory.createElementNS("http://www.eclipse.org/smila/record", tag);
        this.newline(factory, element);
        parentElement.appendChild(element);
        this.newline(factory, parentElement);
        return element;
    }

    private Element appendTextElement(Document factory, Element element, String name, String text) {
        Element textElement = factory.createElementNS("http://www.eclipse.org/smila/record", name);
        textElement.appendChild(factory.createTextNode(DOMRecordWriter.cleanText(text)));
        element.appendChild(textElement);
        this.newline(factory, element);
        return textElement;
    }

    private void newline(Document factory, Element element) {
        if (this._printPretty) {
            element.appendChild(factory.createTextNode("\n"));
        }
    }

    protected static String cleanText(String text) {
        return StringUtils.replace((String)text, (String)"\u0000", (String)" ");
    }
}

