/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.IOUtils;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.xml.DOMRecordReader;
import org.eclipse.smila.datamodel.xml.DeserializationException;
import org.eclipse.smila.datamodel.xml.StaxRecordReader;
import org.eclipse.smila.datamodel.xml.StaxRecordWriter;
import org.w3c.dom.Document;

public final class XmlSerializationUtils {
    private static DOMRecordReader s_recordParser;
    private static XMLOutputFactory s_staxWriterFactory;
    private static XMLInputFactory s_staxReaderFactory;
    private static StaxRecordWriter s_recordWriter;
    private static StaxRecordReader s_recordReader;

    private XmlSerializationUtils() {
    }

    public static String serialize2string(Record record) {
        if (record == null) {
            return null;
        }
        try {
            ByteArrayOutputStream out = XmlSerializationUtils.serialize2stream(record);
            return out.toString("utf-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] serialize2byteArray(Record record) {
        if (record == null) {
            return null;
        }
        try {
            RecordByteWrapper wrapper = new RecordByteWrapper(XmlSerializationUtils.serialize2stream(record).toByteArray());
            Iterator<String> attachmentNames = record.getAttachmentNames();
            while (attachmentNames.hasNext()) {
                String attachmentName = attachmentNames.next();
                wrapper.getAttachments().put(attachmentName, record.getAttachment(attachmentName));
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = null;
            try {
                try {
                    out = new ObjectOutputStream(bos);
                    out.writeObject(wrapper);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                IOUtils.closeQuietly((OutputStream)bos);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)out);
            IOUtils.closeQuietly((OutputStream)bos);
            return bos.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ByteArrayOutputStream serialize2stream(Record record) {
        if (record == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLStreamWriter writer = null;
        try {
            try {
                writer = XmlSerializationUtils.getStaxWriterFactory().createXMLStreamWriter(out, "utf-8");
                writer.writeStartDocument("utf-8", "1.1");
                XmlSerializationUtils.getRecordWriter().writeRecord(writer, record);
                writer.writeEndDocument();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        catch (Throwable throwable) {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
            if (out != null) {
                IOUtils.closeQuietly((OutputStream)out);
            }
            throw throwable;
        }
        if (writer != null) {
            try {
                writer.close();
            }
            catch (XMLStreamException xMLStreamException) {}
        }
        if (out != null) {
            IOUtils.closeQuietly((OutputStream)out);
        }
        return out;
    }

    public static Record deserialize(byte[] byteArray) throws DeserializationException {
        Record record;
        ByteArrayInputStream bis = new ByteArrayInputStream(byteArray);
        ObjectInputStream wrapperInputStream = null;
        ByteArrayInputStream recordInputStream = new ByteArrayInputStream(byteArray);
        try {
            RecordByteWrapper wrapper = null;
            try {
                wrapperInputStream = new ObjectInputStream(bis);
                wrapper = (RecordByteWrapper)wrapperInputStream.readObject();
                recordInputStream = wrapper.getRecordAsStream();
            }
            catch (Exception e) {
                throw new DeserializationException(e);
            }
            XMLStreamReader reader = XmlSerializationUtils.getStaxReaderFactory().createXMLStreamReader(recordInputStream);
            reader.nextTag();
            Record record2 = XmlSerializationUtils.getRecordReader().readRecord(reader);
            if (wrapper.getAttachments() != null && !wrapper.getAttachments().isEmpty()) {
                for (String attachmentName : wrapper.getAttachments().keySet()) {
                    record2.setAttachment(attachmentName, wrapper.getAttachments().get(attachmentName));
                }
            }
            record = record2;
        }
        catch (XMLStreamException e) {
            try {
                throw new DeserializationException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)bis);
                IOUtils.closeQuietly(wrapperInputStream);
                IOUtils.closeQuietly((InputStream)recordInputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)bis);
        IOUtils.closeQuietly((InputStream)wrapperInputStream);
        IOUtils.closeQuietly((InputStream)recordInputStream);
        return record;
    }

    public static Record deserialize(String xmlString) throws DeserializationException {
        try {
            return XmlSerializationUtils.deserialize(xmlString.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new DeserializationException(e);
        }
    }

    public static Record deserialize(Document document) throws DeserializationException {
        try {
            if (document == null || document.getDocumentElement() == null) {
                throw new DeserializationException("No XML document found");
            }
            return XmlSerializationUtils.getRecordParser().parseRecordFrom(document.getDocumentElement());
        }
        catch (Exception e) {
            throw new DeserializationException(e);
        }
    }

    public static DOMRecordReader getRecordParser() {
        if (s_recordParser == null) {
            s_recordParser = new DOMRecordReader();
        }
        return s_recordParser;
    }

    public static XMLOutputFactory getStaxWriterFactory() {
        if (s_staxWriterFactory == null) {
            s_staxWriterFactory = XMLOutputFactory.newInstance();
        }
        return s_staxWriterFactory;
    }

    public static XMLInputFactory getStaxReaderFactory() {
        if (s_staxReaderFactory == null) {
            s_staxReaderFactory = XMLInputFactory.newInstance();
        }
        return s_staxReaderFactory;
    }

    public static StaxRecordWriter getRecordWriter() {
        if (s_recordWriter == null) {
            s_recordWriter = new StaxRecordWriter(true);
        }
        return s_recordWriter;
    }

    public static StaxRecordReader getRecordReader() {
        if (s_recordReader == null) {
            s_recordReader = new StaxRecordReader();
        }
        return s_recordReader;
    }

    private static class RecordByteWrapper
    implements Serializable {
        private static final long serialVersionUID = -6375342925771895197L;
        private final byte[] _recordBytes;
        private final Map<String, byte[]> _attachments = new HashMap<String, byte[]>();

        public RecordByteWrapper(byte[] recordBytes) {
            this._recordBytes = recordBytes;
        }

        public ByteArrayInputStream getRecordAsStream() {
            return new ByteArrayInputStream(this._recordBytes);
        }

        public Map<String, byte[]> getAttachments() {
            return this._attachments;
        }
    }
}

