/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.bpel;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.utils.DOMUtils;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.filter.RecordFilterNotFoundException;
import org.eclipse.smila.datamodel.xml.DOMRecordReader;
import org.eclipse.smila.datamodel.xml.DOMRecordWriter;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.bpel.ODEWorkflowProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class MessageHelper {
    private final Log _log = LogFactory.getLog(ODEWorkflowProcessor.class);
    private final DOMRecordWriter _recordWriter = new DOMRecordWriter();
    private final DOMRecordReader _recordReader = new DOMRecordReader();
    private final Properties _properties;

    public MessageHelper(Properties properties) {
        this._properties = properties;
    }

    public String parseRequestId(Element message) {
        Element part = DOMUtils.getFirstChildElement((Element)message);
        Element idNode = DOMUtils.getFirstChildElement((Element)part);
        String requestId = idNode.getTextContent();
        return requestId;
    }

    public String[] parseMessage(Blackboard blackboard, Element message) {
        Element recordsPart = this.findChildByName(message, "records");
        Element recordList = this.findChildByName(recordsPart, "RecordList");
        List workflowRecords = this._recordReader.parseRecordsIn(recordList);
        return this.synchronizeBlackboard(blackboard, workflowRecords);
    }

    public Element createMessage(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        List<Record> workflowRecords = this.createWorkflowObjects(blackboard, recordIds);
        Document doc = DOMUtils.newDocument();
        Element message = doc.createElementNS(null, "message");
        Element part = doc.createElementNS(null, "records");
        message.appendChild(part);
        this._recordWriter.appendRecordList(part, workflowRecords);
        return message;
    }

    public void addRequestId(Element message, String requestId, QName varType) {
        Element idNode = this.createRequestIdNode(requestId, message.getOwnerDocument());
        Element idPart = message.getOwnerDocument().createElementNS(null, "id");
        idPart.appendChild(idNode);
        idNode = idPart;
        if (DOMUtils.isEmptyElement((Element)message)) {
            message.appendChild(idNode);
        } else {
            message.insertBefore(idNode, DOMUtils.getFirstChildElement((Element)message));
        }
    }

    private Element findChildByName(Element parent, String name) {
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            String nodeName;
            Node c = children.item(i);
            if (c.getNodeType() == 1 && name.equals(nodeName = c.getNodeName())) {
                return (Element)c;
            }
            ++i;
        }
        return null;
    }

    private List<Record> createWorkflowObjects(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        if (recordIds == null) {
            this._log.error((Object)"null list of ids passed to create workflow objects.");
            throw new ProcessingException("no list of ids passed to create workflow objects.");
        }
        ArrayList<Record> workflowRecords = new ArrayList<Record>(recordIds.length);
        String[] stringArray = recordIds;
        int n = recordIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            Record workflowRecord = this.createWorkflowRecord(blackboard, id);
            workflowRecords.add(workflowRecord);
            ++n2;
        }
        return workflowRecords;
    }

    private Record createWorkflowRecord(Blackboard blackboard, String id) throws ProcessingException {
        if (id == null) {
            this._log.error((Object)"cannot create workflow object from null record id.");
            throw new ProcessingException("can not create workflow object from null record id.");
        }
        Record workflowRecord = null;
        String recordFilterName = this._properties.getProperty("record.filter");
        if (recordFilterName != null) {
            try {
                workflowRecord = blackboard.getRecord(id, recordFilterName);
            }
            catch (RecordFilterNotFoundException ex) {
                this._log.error((Object)("unknown record filter name " + recordFilterName + " in workflow object creation."), (Throwable)ex);
                throw new ProcessingException("unknown record filter name " + recordFilterName + " in workflow object creation.", (Throwable)ex);
            }
            catch (BlackboardAccessException ex) {
                this._log.error((Object)("cannot create workflow object from record " + id), (Throwable)ex);
                throw new ProcessingException("cannot create workflow object from record " + id, (Throwable)ex);
            }
        }
        if (workflowRecord == null) {
            workflowRecord = blackboard.getDataFactory().createRecord(id);
            try {
                workflowRecord.setSource(blackboard.getRecord(id).getSource());
            }
            catch (BlackboardAccessException blackboardAccessException) {}
        }
        return workflowRecord;
    }

    private String[] synchronizeBlackboard(Blackboard blackboard, List<Record> workflowRecords) {
        String[] recordIds = new String[workflowRecords.size()];
        int i = 0;
        while (i < recordIds.length) {
            Record record = workflowRecords.get(i);
            recordIds[i] = record.getId();
            try {
                blackboard.synchronizeRecord(record);
            }
            catch (BlackboardAccessException e) {
                this._log.error((Object)("error syncing record " + recordIds[i] + " with blackboard"), (Throwable)e);
            }
            ++i;
        }
        return recordIds;
    }

    private Element createRequestIdNode(String requestId, Document doc) {
        Element idNode = doc.createElementNS("http://www.eclipse.org/smila/processor", "ReqId");
        Text content = doc.createTextNode(requestId);
        idNode.appendChild(content);
        return idNode;
    }
}

