/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Processor;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.file.FileExchange;
import org.apache.camel.component.file.FileProcessStrategy;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.camel.processor.DeadLetterChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileConsumer
extends ScheduledPollConsumer<FileExchange> {
    private static final transient Log LOG = LogFactory.getLog(FileConsumer.class);
    private FileEndpoint endpoint;
    private ConcurrentHashMap<File, File> filesBeingProcessed = new ConcurrentHashMap();
    private ConcurrentHashMap<File, Long> fileSizes = new ConcurrentHashMap();
    private ConcurrentHashMap<File, Long> noopMap = new ConcurrentHashMap();
    private boolean generateEmptyExchangeWhenIdle;
    private boolean recursive = true;
    private String regexPattern = "";
    private long lastPollTime;
    private int unchangedDelay;
    private boolean unchangedSize;

    public FileConsumer(FileEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = endpoint;
    }

    @Override
    protected synchronized void poll() throws Exception {
        int rc = this.pollFileOrDirectory(this.endpoint.getFile(), this.isRecursive());
        if (rc == 0 && this.generateEmptyExchangeWhenIdle) {
            FileExchange exchange = this.endpoint.createExchange((File)null);
            this.getAsyncProcessor().process(exchange, new AsyncCallback(){

                public void done(boolean sync) {
                }
            });
        }
        this.lastPollTime = System.currentTimeMillis();
    }

    protected int pollFileOrDirectory(File fileOrDirectory, boolean processDir) {
        if (!fileOrDirectory.isDirectory()) {
            return this.pollFile(fileOrDirectory);
        }
        if (processDir) {
            int rc = 0;
            if (this.isValidFile(fileOrDirectory)) {
                File[] files;
                LOG.debug((Object)("Polling directory " + fileOrDirectory));
                for (File file : files = fileOrDirectory.listFiles()) {
                    rc += this.pollFileOrDirectory(file, this.isRecursive());
                }
            }
            return rc;
        }
        LOG.debug((Object)("Skipping directory " + fileOrDirectory));
        return 0;
    }

    protected int pollFile(final File file) {
        if (!file.exists()) {
            return 0;
        }
        if (!this.isValidFile(file)) {
            return 0;
        }
        if (!this.endpoint.isNoop()) {
            if (this.filesBeingProcessed.contains(file)) {
                return 1;
            }
            this.filesBeingProcessed.put(file, file);
        }
        final FileProcessStrategy processStrategy = this.endpoint.getFileStrategy();
        final FileExchange exchange = this.endpoint.createExchange(file);
        this.endpoint.configureMessage(file, exchange.getIn());
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("About to process file: " + file + " using exchange: " + exchange));
            }
            if (processStrategy.begin(this.endpoint, exchange, file)) {
                this.getAsyncProcessor().process(exchange, new AsyncCallback(){

                    public void done(boolean sync) {
                        boolean failed = exchange.isFailed();
                        boolean handled = DeadLetterChannel.isFailureHandled(exchange);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Done processing file: " + file + ". Status is: " + (failed ? "failed: " + failed + ", handled by failure processor: " + handled : "OK")));
                        }
                        if (!failed || handled) {
                            FileConsumer.this.processStrategyCommit(processStrategy, exchange, file, handled);
                        } else if (failed && !handled) {
                            FileConsumer.this.handleException(exchange.getException());
                        }
                        FileConsumer.this.filesBeingProcessed.remove(file);
                    }
                });
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.endpoint + " cannot process file: " + file));
            }
        }
        catch (Throwable e) {
            this.handleException(e);
        }
        return 1;
    }

    protected void processStrategyCommit(FileProcessStrategy processStrategy, FileExchange exchange, File file, boolean failureHandled) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Committing file strategy: " + processStrategy + " for file: " + file + (failureHandled ? " that was handled by the failure processor." : "")));
            }
            processStrategy.commit(this.endpoint, exchange, file);
        }
        catch (Exception e) {
            LOG.warn((Object)("Error committing file strategy: " + processStrategy), (Throwable)e);
            this.handleException(e);
        }
    }

    protected boolean isValidFile(File file) {
        boolean result = false;
        if (file != null && file.exists() && this.isMatched(file) && this.isChanged(file)) {
            result = true;
        }
        return result;
    }

    protected boolean isChanged(File file) {
        boolean answer;
        if (file == null) {
            return false;
        }
        if (file.isDirectory()) {
            return true;
        }
        boolean lastModifiedCheck = false;
        long modifiedDuration = 0L;
        if (this.getUnchangedDelay() > 0) {
            modifiedDuration = System.currentTimeMillis() - file.lastModified();
            lastModifiedCheck = modifiedDuration >= (long)this.getUnchangedDelay();
        }
        long fileModified = file.lastModified();
        Long previousModified = this.noopMap.get(file);
        this.noopMap.put(file, fileModified);
        if (previousModified == null || fileModified > previousModified) {
            lastModifiedCheck = true;
        }
        boolean sizeCheck = false;
        long sizeDifference = 0L;
        if (this.isUnchangedSize()) {
            Long value = this.fileSizes.get(file);
            sizeCheck = value == null ? true : file.length() != value.longValue();
        }
        boolean bl = answer = lastModifiedCheck || sizeCheck;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("file:" + file + " isChanged:" + answer + " " + "sizeCheck:" + sizeCheck + "(" + sizeDifference + ") " + "lastModifiedCheck:" + lastModifiedCheck + "(" + modifiedDuration + ")"));
        }
        if (this.isUnchangedSize()) {
            if (answer) {
                this.fileSizes.put(file, file.length());
            } else {
                this.fileSizes.remove(file);
            }
        }
        return answer;
    }

    protected boolean isMatched(File file) {
        String[] postfixes;
        String name = file.getName();
        if (this.regexPattern != null && this.regexPattern.length() > 0 && !name.matches(this.getRegexPattern())) {
            return false;
        }
        String[] prefixes = this.endpoint.getExcludedNamePrefixes();
        if (prefixes != null) {
            for (String prefix : prefixes) {
                if (!name.startsWith(prefix)) continue;
                return false;
            }
        }
        if ((postfixes = this.endpoint.getExcludedNamePostfixes()) != null) {
            for (String postfix : postfixes) {
                if (!name.endsWith(postfix)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public String getRegexPattern() {
        return this.regexPattern;
    }

    public void setRegexPattern(String regexPattern) {
        this.regexPattern = regexPattern;
    }

    public boolean isGenerateEmptyExchangeWhenIdle() {
        return this.generateEmptyExchangeWhenIdle;
    }

    public void setGenerateEmptyExchangeWhenIdle(boolean generateEmptyExchangeWhenIdle) {
        this.generateEmptyExchangeWhenIdle = generateEmptyExchangeWhenIdle;
    }

    public int getUnchangedDelay() {
        return this.unchangedDelay;
    }

    public void setUnchangedDelay(int unchangedDelay) {
        this.unchangedDelay = unchangedDelay;
    }

    public boolean isUnchangedSize() {
        return this.unchangedSize;
    }

    public void setUnchangedSize(boolean unchangedSize) {
        this.unchangedSize = unchangedSize;
    }
}

