/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.builder.ExpressionClause;
import org.apache.camel.model.CompletedPredicate;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.language.ExpressionType;
import org.apache.camel.processor.Aggregator;
import org.apache.camel.processor.aggregate.AggregationCollection;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.apache.camel.spi.RouteContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="aggregator")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AggregatorType
extends ExpressionNode {
    @XmlTransient
    private AggregationStrategy aggregationStrategy;
    @XmlTransient
    private AggregationCollection aggregationCollection;
    @XmlAttribute(required=false)
    private Integer batchSize;
    @XmlAttribute(required=false)
    private Long batchTimeout;
    @XmlAttribute(required=false)
    private String strategyRef;
    @XmlElement(name="completedPredicate", required=false)
    private CompletedPredicate completedPredicate;

    public AggregatorType() {
    }

    public AggregatorType(Expression correlationExpression) {
        super(correlationExpression);
    }

    public AggregatorType(ExpressionType correlationExpression) {
        super(correlationExpression);
    }

    public AggregatorType(Expression correlationExpression, AggregationStrategy aggregationStrategy) {
        super(correlationExpression);
        this.aggregationStrategy = aggregationStrategy;
    }

    public String toString() {
        return "Aggregator[ " + this.getExpression() + " -> " + this.getOutputs() + "]";
    }

    @Override
    public String getShortName() {
        return "aggregator";
    }

    @Override
    public void addRoutes(RouteContext routeContext, Collection<Route> routes) throws Exception {
        Aggregator aggregator = this.createAggregator(routeContext);
        this.doAddRoute(routeContext, routes, aggregator);
    }

    private void doAddRoute(RouteContext routeContext, Collection<Route> routes, final Aggregator aggregator) throws Exception {
        Route<Exchange> route = new Route<Exchange>(aggregator.getEndpoint(), new Service[]{aggregator}){

            @Override
            public String toString() {
                return "AggregatorRoute[" + this.getEndpoint() + " -> " + aggregator.getProcessor() + "]";
            }
        };
        routes.add(route);
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Aggregator aggregator = this.createAggregator(routeContext);
        this.doAddRoute(routeContext, routeContext.getCamelContext().getRoutes(), aggregator);
        routeContext.setIsRouteAdded(true);
        return aggregator;
    }

    protected Aggregator createAggregator(RouteContext routeContext) throws Exception {
        Aggregator aggregator;
        Endpoint<? extends Exchange> from = routeContext.getEndpoint();
        Processor processor = routeContext.createProcessor(this);
        if (this.aggregationCollection != null) {
            aggregator = new Aggregator(from, processor, this.aggregationCollection);
        } else {
            AggregationStrategy strategy = this.getAggregationStrategy();
            if (strategy == null && this.strategyRef != null) {
                strategy = routeContext.lookup(this.strategyRef, AggregationStrategy.class);
            }
            if (strategy == null) {
                strategy = new UseLatestAggregationStrategy();
            }
            Expression aggregateExpression = this.getExpression().createExpression(routeContext);
            Predicate predicate = null;
            if (this.completedPredicate != null) {
                predicate = this.completedPredicate.createPredicate(routeContext);
            }
            aggregator = predicate != null ? new Aggregator(from, processor, aggregateExpression, strategy, predicate) : new Aggregator(from, processor, aggregateExpression, strategy);
        }
        if (this.batchSize != null) {
            aggregator.setBatchSize(this.batchSize);
        }
        if (this.batchTimeout != null) {
            aggregator.setBatchTimeout(this.batchTimeout);
        }
        return aggregator;
    }

    public AggregationCollection getAggregationCollection() {
        return this.aggregationCollection;
    }

    public void setAggregationCollection(AggregationCollection aggregationCollection) {
        this.aggregationCollection = aggregationCollection;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public Long getBatchTimeout() {
        return this.batchTimeout;
    }

    public void setBatchTimeout(Long batchTimeout) {
        this.batchTimeout = batchTimeout;
    }

    public String getStrategyRef() {
        return this.strategyRef;
    }

    public void setStrategyRef(String strategyRef) {
        this.strategyRef = strategyRef;
    }

    public CompletedPredicate getCompletePredicate() {
        return this.completedPredicate;
    }

    public void setCompletePredicate(CompletedPredicate completedPredicate) {
        this.completedPredicate = completedPredicate;
    }

    public AggregatorType batchSize(int batchSize) {
        this.setBatchSize(batchSize);
        return this;
    }

    public AggregatorType batchTimeout(long batchTimeout) {
        this.setBatchTimeout(batchTimeout);
        return this;
    }

    public ExpressionClause<AggregatorType> completedPredicate() {
        this.checkNoCompletedPredicate();
        ExpressionClause<AggregatorType> clause = new ExpressionClause<AggregatorType>(this);
        this.completedPredicate = new CompletedPredicate(clause);
        return clause;
    }

    public AggregatorType completedPredicate(Predicate predicate) {
        this.checkNoCompletedPredicate();
        this.completedPredicate = new CompletedPredicate(predicate);
        return this;
    }

    protected void checkNoCompletedPredicate() {
        if (this.completedPredicate != null) {
            throw new IllegalArgumentException("There already is a completedPredicate defined for this aggregator: " + this);
        }
    }
}

