/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.resequencer;

import java.util.Queue;
import java.util.Timer;
import org.apache.camel.processor.resequencer.Element;
import org.apache.camel.processor.resequencer.ElementComparator;
import org.apache.camel.processor.resequencer.Sequence;
import org.apache.camel.processor.resequencer.SequenceElementComparator;
import org.apache.camel.processor.resequencer.Timeout;
import org.apache.camel.processor.resequencer.TimeoutHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResequencerEngine<E>
implements TimeoutHandler {
    private static final transient Log LOG = LogFactory.getLog(ResequencerEngine.class);
    private long timeout;
    private int capacity;
    private Queue<E> outQueue;
    private Element<E> lastDelivered;
    private Sequence<Element<E>> sequence;
    private Timer timer = new Timer("Resequencer Timer");

    public ResequencerEngine(SequenceElementComparator<E> comparator) {
        this(comparator, Integer.MAX_VALUE);
    }

    public ResequencerEngine(SequenceElementComparator<E> comparator, int capacity) {
        this.sequence = ResequencerEngine.createSequence(comparator);
        this.capacity = capacity;
        this.timeout = 2000L;
        this.lastDelivered = null;
    }

    public void stop() {
        this.timer.cancel();
    }

    public Queue<E> getOutQueue() {
        return this.outQueue;
    }

    public void setOutQueue(Queue<E> outQueue) {
        this.outQueue = outQueue;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public synchronized void timeout(Timeout timout) {
        try {
            while (this.deliver()) {
            }
        }
        catch (RuntimeException e) {
            LOG.error((Object)"error during delivery", (Throwable)e);
        }
    }

    public synchronized void add(E o) {
        if (this.sequence.size() >= this.capacity) {
            throw new IllegalStateException("maximum capacity is reached");
        }
        this.insert(o);
    }

    public synchronized void put(E o) throws InterruptedException {
        if (this.sequence.size() >= this.capacity) {
            this.wait();
        }
        this.insert(o);
    }

    E getLastDelivered() {
        if (this.lastDelivered == null) {
            return null;
        }
        return this.lastDelivered.getObject();
    }

    void setLastDelivered(E o) {
        this.lastDelivered = new Element<E>(o);
    }

    private void insert(E o) {
        Element<E> element = new Element<E>(o);
        this.sequence.add(element);
        Element<E> successor = this.sequence.successor(element);
        if (successor != null) {
            successor.cancel();
        }
        if (!this.successorOfLastDelivered(element) && this.sequence.predecessor(element) == null) {
            Timeout t = this.defineTimeout();
            element.schedule(t);
        }
        while (this.deliver()) {
        }
    }

    private boolean deliver() {
        if (this.sequence.size() == 0) {
            return false;
        }
        Element element = (Element)this.sequence.first();
        if (element.scheduled()) {
            return false;
        }
        this.sequence.remove(element);
        this.lastDelivered = element;
        this.notify();
        this.outQueue.add(element.getObject());
        return true;
    }

    private boolean successorOfLastDelivered(Element<E> element) {
        if (this.lastDelivered == null) {
            return false;
        }
        return this.sequence.comparator().successor(element, this.lastDelivered);
    }

    private Timeout defineTimeout() {
        Timeout result = new Timeout(this.timer, this.timeout);
        result.addTimeoutHandler(this);
        return result;
    }

    private static <E> Sequence<Element<E>> createSequence(SequenceElementComparator<E> comparator) {
        return new Sequence<Element<E>>(new ElementComparator<E>(comparator));
    }
}

