/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.datadictionary.messages.ddconfig;

import java.util.Iterator;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.ConfigurationException;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.DConfiguration;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.DDefaultConfigCodec;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.DNamedConfig;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.DNamedConfigCodec;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.DQueryConstraintsCodec;
import org.eclipse.smila.utils.xml.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class DConfigurationCodec {
    public static final String NS = "http://www.anyfinder.de/DataDictionary/Configuration";

    public static DConfiguration decode(Element element) throws ConfigurationException {
        DConfiguration dConfiguration = new DConfiguration();
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if ("DefaultConfig".equals(nl.item(i).getLocalName())) {
                dConfiguration.setDefaultConfig(DDefaultConfigCodec.decode((Element)nl.item(i)));
            } else if ("NamedConfig".equals(nl.item(i).getLocalName())) {
                dConfiguration.addNamedConfig(DNamedConfigCodec.decode((Element)nl.item(i)));
            } else if ("QueryConstraints".equals(nl.item(i).getLocalName())) {
                dConfiguration.setQueryConstraints(DQueryConstraintsCodec.decode((Element)nl.item(i)));
            }
            ++i;
        }
        return dConfiguration;
    }

    public static Document encode(DConfiguration dConfiguration) throws ConfigurationException {
        Document doc = XMLUtils.getDocument();
        Element el = doc.createElementNS(NS, "Configuration");
        doc.appendChild(el);
        Attr attr = null;
        attr = doc.createAttribute("xmlns:xsi");
        attr.setValue("http://www.w3.org/2001/XMLSchema-instance");
        el.setAttributeNode(attr);
        attr = doc.createAttribute("xsi:schemaLocation");
        attr.setValue("http://www.anyfinder.de/DataDictionary/Configuration ../xml/DataDictionaryConfiguration.xsd");
        el.setAttributeNode(attr);
        DDefaultConfigCodec.encode(dConfiguration.getDefaultConfig(), el);
        Iterator it = dConfiguration.getNamedConfigs();
        while (it.hasNext()) {
            DNamedConfigCodec.encode((DNamedConfig)it.next(), el);
        }
        if (dConfiguration.getQueryConstraints() != null) {
            DQueryConstraintsCodec.encode(dConfiguration.getQueryConstraints(), el);
        }
        return doc;
    }

    public static Element encode(DConfiguration dConfiguration, Element element) throws ConfigurationException {
        Document doc = element.getOwnerDocument();
        Element el = doc.createElementNS(NS, "Configuration");
        element.appendChild(el);
        Attr attr = null;
        attr = doc.createAttribute("xmlns:xsi");
        attr.setValue("http://www.w3.org/2001/XMLSchema-instance");
        el.setAttributeNode(attr);
        attr = doc.createAttribute("xsi:schemaLocation");
        attr.setValue("http://www.anyfinder.de/DataDictionary/Configuration ../xml/DataDictionaryConfiguration.xsd");
        el.setAttributeNode(attr);
        DDefaultConfigCodec.encode(dConfiguration.getDefaultConfig(), el);
        Iterator it = dConfiguration.getNamedConfigs();
        while (it.hasNext()) {
            DNamedConfigCodec.encode((DNamedConfig)it.next(), el);
        }
        if (dConfiguration.getQueryConstraints() != null) {
            DQueryConstraintsCodec.encode(dConfiguration.getQueryConstraints(), el);
        }
        return el;
    }
}

