/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.utils.param;

import java.lang.reflect.Method;
import java.util.Enumeration;
import org.eclipse.smila.search.utils.param.ParameterException;
import org.eclipse.smila.search.utils.param.ParameterSet;
import org.eclipse.smila.search.utils.param.def.DParameterDefinition;
import org.eclipse.smila.search.utils.param.set.DParameterSet;

public abstract class ParameterSetUtils {
    private ParameterSetUtils() {
    }

    public static void assingParameterSet(DParameterSet dParameterSet, DParameterDefinition dParameterDefinition, Object target) throws ParameterException {
        ParameterSet paramSet;
        try {
            paramSet = new ParameterSet(dParameterSet, dParameterDefinition);
        }
        catch (ParameterException e) {
            throw new ParameterException("unable to parse parameters", e);
        }
        Enumeration params = paramSet.getParameterNames();
        while (params.hasMoreElements()) {
            String paramName = (String)params.nextElement();
            Object o = paramSet.getParameter(paramName);
            try {
                Class<?> javaType = o.getClass();
                Method property = target.getClass().getMethod("set" + paramName, javaType);
                property.invoke(target, o);
            }
            catch (Throwable e) {
                throw new ParameterException("unable to assign parameter [" + paramName + "]", e);
            }
        }
    }
}

