/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.utils.searchresult;

import java.util.Enumeration;
import org.eclipse.smila.search.utils.searchresult.DHit;
import org.eclipse.smila.search.utils.searchresult.DHitCodec;
import org.eclipse.smila.search.utils.searchresult.DHitDistribution;
import org.eclipse.smila.search.utils.searchresult.DSearchResultException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

abstract class DHitDistributionCodec {
    public static final String NS = "http://www.anyfinder.de/SearchResult";

    protected static DHitDistribution decode(Element element) throws DSearchResultException {
        DHitDistribution dHitDistribution = new DHitDistribution();
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if ("Hit".equals(nl.item(i).getLocalName())) {
                dHitDistribution.addHit(DHitCodec.decode((Element)nl.item(i)));
            }
            ++i;
        }
        return dHitDistribution;
    }

    protected static Element encode(DHitDistribution dHitDistribution, Element element) throws DSearchResultException {
        Document doc = element.getOwnerDocument();
        Element el = doc.createElementNS(NS, "HitDistribution");
        Enumeration<DHit> hits = dHitDistribution.getHits();
        while (hits.hasMoreElements()) {
            DHitCodec.encode(hits.nextElement(), el);
        }
        element.appendChild(el);
        return el;
    }

    private DHitDistributionCodec() {
    }
}

