/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ValueFormatHelper {
    public static final ValueFormatHelper INSTANCE = new ValueFormatHelper();
    private static final int DATE_LENGTH = 10;
    private static final int DATE_TIME_LENGTH_PATTERN_DEFAULT = 28;
    private static final int DATE_TIME_LENGTH_PATTERN_2 = 24;
    private static final int DATE_TIME_LENGTH_PATTERN_3 = 23;
    private static final int DATE_TIME_LENGTH_PATTERN_4 = 19;
    private final DateFormat _formatDate = new SimpleDateFormat("yyyy-MM-dd");
    private final DateFormat _formatDateTimePatternDefault = ValueFormatHelper.getDefaulDateTimeFormat();
    private final DateFormat _formatDateTimePattern2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private final DateFormat _formatDateTimePattern3 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private final DateFormat _formatDateTimePattern4 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public static SimpleDateFormat getDefaulDateTimeFormat() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String formatDate(Date value) {
        DateFormat dateFormat = this._formatDate;
        synchronized (dateFormat) {
            return this._formatDate.format(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String formatDateTime(Date value) {
        DateFormat dateFormat = this._formatDateTimePatternDefault;
        synchronized (dateFormat) {
            return this._formatDateTimePatternDefault.format(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date parseDate(String dateString) throws ParseException {
        if (dateString.length() == 10) {
            DateFormat dateFormat = this._formatDate;
            synchronized (dateFormat) {
                return this._formatDate.parse(dateString);
            }
        }
        throw new ParseException("Length of date string '" + dateString + "' exceeds maximum date length of " + 10, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date parseDateTime(String dateTimeString) throws ParseException {
        if (dateTimeString.length() == 28) {
            DateFormat dateFormat = this._formatDateTimePatternDefault;
            synchronized (dateFormat) {
                return this._formatDateTimePatternDefault.parse(dateTimeString);
            }
        }
        if (dateTimeString.length() == 24) {
            DateFormat dateFormat = this._formatDateTimePattern2;
            synchronized (dateFormat) {
                return this._formatDateTimePattern2.parse(dateTimeString);
            }
        }
        if (dateTimeString.length() == 23) {
            DateFormat dateFormat = this._formatDateTimePattern3;
            synchronized (dateFormat) {
                return this._formatDateTimePattern3.parse(dateTimeString);
            }
        }
        if (dateTimeString.length() == 19) {
            DateFormat dateFormat = this._formatDateTimePattern4;
            synchronized (dateFormat) {
                return this._formatDateTimePattern4.parse(dateTimeString);
            }
        }
        throw new ParseException("Length '" + dateTimeString.length() + "' of datetime string '" + dateTimeString + "' doesn't match expected pattern length", dateTimeString.length());
    }
}

