/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.xml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.DataFactoryCreator;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;

public class StaxRecordReader {
    private DataFactory _dataFactory;

    public StaxRecordReader() {
        this(DataFactoryCreator.createDefaultFactory());
    }

    public StaxRecordReader(DataFactory dataFactory) {
        this._dataFactory = dataFactory;
    }

    public List<Record> readRecords(XMLStreamReader staxReader) throws XMLStreamException {
        ArrayList<Record> records = new ArrayList<Record>();
        if (this.isStartTag(staxReader, "RecordList")) {
            staxReader.nextTag();
            while (this.isStartTag(staxReader, "Record")) {
                records.add(this.readRecord(staxReader));
                staxReader.nextTag();
            }
        }
        return records;
    }

    public Record readRecord(XMLStreamReader staxReader) throws XMLStreamException {
        Record record = null;
        if (this.isStartTag(staxReader, "Record")) {
            record = this._dataFactory.createRecord();
            staxReader.nextTag();
            record.getMetadata().putAll(this.readMetadata(staxReader));
            this.readAttachments(staxReader, record);
        }
        return record;
    }

    private AnyMap readMetadata(XMLStreamReader staxReader) throws XMLStreamException {
        AnyMap metaData = this._dataFactory.createAnyMap();
        while (this.isStartTag(staxReader, "Val") || this.isStartTag(staxReader, "Seq") || this.isStartTag(staxReader, "Map")) {
            if (this.isStartTag(staxReader, "Val")) {
                this.readValue(staxReader, metaData);
            } else if (this.isStartTag(staxReader, "Seq")) {
                this.readSeq(staxReader, metaData);
            } else if (this.isStartTag(staxReader, "Map")) {
                this.readMap(staxReader, metaData);
            }
            staxReader.nextTag();
        }
        return metaData;
    }

    private Value readValue(String value, String type) throws XMLStreamException {
        return this._dataFactory.parseFromString(value, type);
    }

    private void readValue(XMLStreamReader staxReader, Any any) throws XMLStreamException {
        String key = staxReader.getAttributeValue(null, "key");
        String valueType = staxReader.getAttributeValue(null, "type");
        String value = staxReader.getElementText();
        if (any.isMap() && key != null) {
            ((AnyMap)any).put(key, this.readValue(value, valueType));
        } else if (any.isSeq()) {
            ((AnySeq)any).add(this.readValue(value, valueType));
        }
    }

    private void readSeq(XMLStreamReader staxReader, Any any) throws XMLStreamException {
        String key = staxReader.getAttributeValue(null, "key");
        AnySeq seq = this._dataFactory.createAnySeq();
        staxReader.nextTag();
        while (this.isStartTag(staxReader, "Val")) {
            this.readValue(staxReader, seq);
            staxReader.nextTag();
        }
        while (this.isStartTag(staxReader, "Seq")) {
            this.readSeq(staxReader, seq);
            staxReader.nextTag();
        }
        while (this.isStartTag(staxReader, "Map")) {
            this.readMap(staxReader, seq);
            staxReader.nextTag();
        }
        if (any.isMap() && key != null) {
            ((AnyMap)any).put(key, seq);
        } else if (any.isSeq()) {
            ((AnySeq)any).add(seq);
        }
    }

    private void readMap(XMLStreamReader staxReader, Any any) throws XMLStreamException {
        String key = staxReader.getAttributeValue(null, "key");
        AnyMap map = this._dataFactory.createAnyMap();
        staxReader.nextTag();
        while (this.isStartTag(staxReader, "Val")) {
            this.readValue(staxReader, map);
            staxReader.nextTag();
        }
        while (this.isStartTag(staxReader, "Seq")) {
            this.readSeq(staxReader, map);
            staxReader.nextTag();
        }
        while (this.isStartTag(staxReader, "Map")) {
            this.readMap(staxReader, map);
            staxReader.nextTag();
        }
        if (any.isMap() && key != null) {
            ((AnyMap)any).put(key, map);
        } else if (any.isSeq()) {
            ((AnySeq)any).add(map);
        }
    }

    private void readAttachments(XMLStreamReader staxReader, Record record) throws XMLStreamException {
        while (this.isStartTag(staxReader, "Attachment")) {
            String attachmentName = staxReader.getElementText();
            if (attachmentName != null && attachmentName.length() > 0) {
                record.setAttachment(attachmentName, null);
            }
            staxReader.nextTag();
        }
    }

    private boolean isStartTag(XMLStreamReader staxReader, String tagName) {
        return staxReader.isStartElement() && tagName.equals(staxReader.getLocalName());
    }
}

