/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.crawler.web.metadata;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smila.connectivity.framework.crawler.web.metadata.Crawler;
import org.eclipse.smila.connectivity.framework.crawler.web.metadata.HttpHeaders;

public class Metadata
implements HttpHeaders,
Crawler {
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static final int THRESHOLD_FACTOR = 3;
    private static Map<String, String> s_namesIdx = new HashMap<String, String>();
    private static String[] s_normalized;
    private final Map<String, Object> _metadata = new HashMap<String, Object>();

    static {
        Field[] fields = Metadata.class.getFields();
        int i = 0;
        while (i < fields.length) {
            int mods = fields[i].getModifiers();
            if (Modifier.isFinal(mods) && Modifier.isPublic(mods) && Modifier.isStatic(mods) && fields[i].getType().equals(String.class)) {
                try {
                    String val = (String)fields[i].get(null);
                    s_namesIdx.put(Metadata.normalize(val), val);
                }
                catch (Exception exception) {}
            }
            ++i;
        }
        s_normalized = s_namesIdx.keySet().toArray(new String[s_namesIdx.size()]);
    }

    public boolean isMultiValued(String name) {
        return this.getValues(name).length > 1;
    }

    public String[] names() {
        Iterator<String> iter = this._metadata.keySet().iterator();
        ArrayList<String> names = new ArrayList<String>();
        while (iter.hasNext()) {
            names.add(Metadata.getNormalizedName(iter.next()));
        }
        return names.toArray(new String[names.size()]);
    }

    public String get(String name) {
        Object values = this._metadata.get(Metadata.getNormalizedName(name));
        if (values != null && values instanceof List) {
            return (String)((List)values).get(0);
        }
        return (String)values;
    }

    public String[] getValues(String name) {
        Object values = this._metadata.get(Metadata.getNormalizedName(name));
        if (values != null) {
            if (values instanceof List) {
                List list = (List)values;
                return list.toArray(new String[list.size()]);
            }
            return new String[]{(String)values};
        }
        return new String[0];
    }

    public void add(String name, String value) {
        String normalized = Metadata.getNormalizedName(name);
        Object values = this._metadata.get(normalized);
        if (values != null) {
            if (values instanceof String) {
                ArrayList<String> list = new ArrayList<String>();
                list.add((String)values);
                list.add(value);
                this._metadata.put(normalized, list);
            } else if (values instanceof List) {
                ((List)values).add(value);
            }
        } else {
            this._metadata.put(normalized, value);
        }
    }

    public void setAll(Properties properties) {
        Enumeration<?> names = properties.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            this.set(name, properties.getProperty(name));
        }
    }

    public void set(String name, String value) {
        this.remove(name);
        this.add(name, value);
    }

    public void remove(String name) {
        this._metadata.remove(Metadata.getNormalizedName(name));
    }

    public int size() {
        return this._metadata.size();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        Metadata other = null;
        try {
            other = (Metadata)o;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (other.size() != this.size()) {
            return false;
        }
        String[] names = this.names();
        int i = 0;
        while (i < names.length) {
            String[] thisValues;
            String[] otherValues = other.getValues(names[i]);
            if (otherValues.length != (thisValues = this.getValues(names[i])).length) {
                return false;
            }
            int j = 0;
            while (j < otherValues.length) {
                if (!otherValues[j].equals(thisValues[j])) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.names().hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String[] names = this.names();
        int i = 0;
        while (i < names.length) {
            String[] values = this.getValues(names[i]);
            int j = 0;
            while (j < values.length) {
                buf.append(names[i]).append("=").append(values[j]).append(" ");
                ++j;
            }
            ++i;
        }
        return buf.toString();
    }

    public List<String> toArrayList() {
        ArrayList<String> metadataArray = new ArrayList<String>();
        String[] names = this.names();
        int i = 0;
        while (i < names.length) {
            String[] values = this.getValues(names[i]);
            int j = 0;
            while (j < values.length) {
                metadataArray.add(String.valueOf(names[i]) + ":" + values[j]);
                ++j;
            }
            ++i;
        }
        return metadataArray;
    }

    public static String getNormalizedName(String name) {
        String searched = Metadata.normalize(name);
        String value = s_namesIdx.get(searched);
        if (value == null && s_normalized != null) {
            int threshold = searched.length() / 3;
            int i = 0;
            while (i < s_normalized.length && value == null) {
                if (StringUtils.getLevenshteinDistance((String)searched, (String)s_normalized[i]) < threshold) {
                    value = s_namesIdx.get(s_normalized[i]);
                }
                ++i;
            }
        }
        if (value != null) {
            return value;
        }
        return name;
    }

    private static String normalize(String str) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (Character.isLetter(c)) {
                buf.append(Character.toLowerCase(c));
            }
            ++i;
        }
        return buf.toString();
    }
}

