/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.eclipse.smila.search.HitsPerIndex;
import org.eclipse.smila.search.QueryScope;
import org.eclipse.smila.search.utils.searchresult.DHit;
import org.eclipse.smila.search.utils.searchresult.DHitDistribution;

public final class FederatedQueryHandling {
    private FederatedQueryHandling() {
    }

    public static QueryScope[] calculateQueries(String[] indexNames, int startHits, int maxHits, HashMap<String, DHitDistribution> hitDistributions) {
        SortedMap<Integer, List<HitsPerIndex>> indicesPerHitLevel = FederatedQueryHandling.calculateIndicesPerHitLevel(indexNames, hitDistributions);
        HashMap<String, QueryScope> queryScopes = FederatedQueryHandling.calculateQueryScopes(startHits, maxHits, indicesPerHitLevel);
        HashMap<String, Integer> resolvedRecords = FederatedQueryHandling.calculateStartPositionForQueryScopes(startHits, maxHits, indicesPerHitLevel);
        for (QueryScope queryScope : queryScopes.values()) {
            if (!resolvedRecords.containsKey(queryScope.getIndexName())) continue;
            queryScope.setStartSelection(resolvedRecords.get(queryScope.getIndexName()));
        }
        ArrayList<QueryScope> queryScopeOrderedResult = new ArrayList<QueryScope>();
        String[] stringArray = indexNames;
        int n = indexNames.length;
        int n2 = 0;
        while (n2 < n) {
            String indexName = stringArray[n2];
            if (queryScopes.containsKey(indexName)) {
                QueryScope queryScope = queryScopes.get(indexName);
                queryScopeOrderedResult.add(queryScope);
                int alreadySpentRecords = queryScope.getStartSelection() - queryScope.getStart() - 1;
                int spendAndSelectedRecords = alreadySpentRecords + queryScope.getRecordsToSelect();
                if (spendAndSelectedRecords > queryScope.getHits()) {
                    int oldRecordsToSelect = queryScope.getRecordsToSelect();
                    queryScope.setRecordsToSelect(queryScope.getHits() - alreadySpentRecords);
                    int newRecordsToSelect = oldRecordsToSelect - queryScope.getRecordsToSelect();
                    queryScope = new QueryScope(queryScope.getIndexName(), queryScope.getStart() + queryScope.getHits(), queryScope.getHits(), newRecordsToSelect, queryScope.getStart() + queryScope.getHits() + 1);
                    queryScopeOrderedResult.add(queryScope);
                }
            }
            ++n2;
        }
        return queryScopeOrderedResult.toArray(new QueryScope[0]);
    }

    private static HashMap<String, Integer> calculateStartPositionForQueryScopes(int startHits, int maxHits, SortedMap<Integer, List<HitsPerIndex>> indicesPerHitLevel) {
        HashMap<String, Integer> positionPerIndex = new HashMap<String, Integer>();
        HashMap<String, Integer> startPositionPerIndex = new HashMap<String, Integer>();
        int hitsFetched = 0;
        int position = 0;
        for (List<HitsPerIndex> hitsPerIndexList : indicesPerHitLevel.values()) {
            for (HitsPerIndex hitsPerIndex : hitsPerIndexList) {
                String indexName = hitsPerIndex.getIndexName();
                if (!positionPerIndex.containsKey(indexName)) {
                    positionPerIndex.put(indexName, 0);
                }
                int positionInIndex = 0;
                positionInIndex = (Integer)positionPerIndex.get(indexName);
                int i = 0;
                while (i < hitsPerIndex.getHits()) {
                    boolean hitsShouldBeFetched;
                    positionPerIndex.put(indexName, ++positionInIndex);
                    boolean bl = hitsShouldBeFetched = hitsFetched < maxHits;
                    if (hitsShouldBeFetched && ++position > startHits) {
                        ++hitsFetched;
                        if (!startPositionPerIndex.containsKey(indexName)) {
                            startPositionPerIndex.put(indexName, positionInIndex);
                        }
                    } else if (!hitsShouldBeFetched) {
                        return startPositionPerIndex;
                    }
                    ++i;
                }
            }
        }
        return startPositionPerIndex;
    }

    private static HashMap<String, QueryScope> calculateQueryScopes(int startHits, int maxHits, SortedMap<Integer, List<HitsPerIndex>> indicesPerHitLevel) {
        HashMap<String, QueryScope> queryScopes = new HashMap<String, QueryScope>();
        HashMap<String, Integer> positionPerIndex = new HashMap<String, Integer>();
        int recordsCollected = 0;
        int currentPosition = 0;
        for (List<HitsPerIndex> hitsPerIndexList : indicesPerHitLevel.values()) {
            for (HitsPerIndex hitsPerIndex : hitsPerIndexList) {
                String indexName = hitsPerIndex.getIndexName();
                if (!positionPerIndex.containsKey(indexName)) {
                    positionPerIndex.put(indexName, 0);
                }
                int positionInIndex = 0;
                positionInIndex = (Integer)positionPerIndex.get(indexName);
                int i = 0;
                while (i < hitsPerIndex.getHits()) {
                    positionPerIndex.put(indexName, ++positionInIndex);
                    if (++currentPosition > startHits) {
                        if (recordsCollected < maxHits) {
                            QueryScope queryScope = null;
                            if (!queryScopes.containsKey(indexName)) {
                                int start = (int)Math.floor((float)(positionInIndex - 1) / (float)maxHits) * maxHits;
                                queryScope = new QueryScope(indexName, start, maxHits);
                                queryScopes.put(indexName, queryScope);
                            } else {
                                queryScope = queryScopes.get(indexName);
                            }
                            ++recordsCollected;
                            queryScope.setRecordsToSelect(queryScope.getRecordsToSelect() + 1);
                        } else {
                            return queryScopes;
                        }
                    }
                    ++i;
                }
            }
        }
        return queryScopes;
    }

    private static SortedMap<Integer, List<HitsPerIndex>> calculateIndicesPerHitLevel(String[] indexNames, HashMap<String, DHitDistribution> hitDistributions) {
        TreeMap<Integer, List<HitsPerIndex>> indicesPerHitLevel = new TreeMap<Integer, List<HitsPerIndex>>((Comparator<Integer>)new ReverseComparator());
        String[] stringArray = indexNames;
        int n = indexNames.length;
        int n2 = 0;
        while (n2 < n) {
            String indexName = stringArray[n2];
            if (hitDistributions.containsKey(indexName)) {
                DHitDistribution hitDistribution = hitDistributions.get(indexName);
                Enumeration hits = hitDistribution.getHits();
                while (hits.hasMoreElements()) {
                    DHit hit = (DHit)hits.nextElement();
                    if (!indicesPerHitLevel.containsKey(hit.getScore())) {
                        indicesPerHitLevel.put(hit.getScore(), new ArrayList());
                    }
                    ((List)indicesPerHitLevel.get(hit.getScore())).add(new HitsPerIndex(indexName, hit.getScore(), hit.getHits()));
                }
            }
            ++n2;
        }
        return indicesPerHitLevel;
    }
}

