/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.templates;

import java.io.File;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.search.datadictionary.DataDictionaryController;
import org.eclipse.smila.search.index.IndexConnection;
import org.eclipse.smila.search.index.IndexException;
import org.eclipse.smila.search.plugin.Plugin;
import org.eclipse.smila.search.plugin.PluginFactory;
import org.eclipse.smila.search.templates.NodeTransformerException;
import org.eclipse.smila.search.templates.TemplateException;
import org.eclipse.smila.search.templates.messages.fieldtemplates.DFieldTemplate;
import org.eclipse.smila.search.templates.messages.fieldtemplates.DFieldTemplates;
import org.eclipse.smila.search.templates.messages.fieldtemplates.DFieldTemplatesCodec;
import org.eclipse.smila.search.templates.messages.fieldtemplates.DFieldTemplatesException;
import org.eclipse.smila.search.templates.messages.fieldtemplates.DSelector;
import org.eclipse.smila.search.templates.messages.searchtemplates.DIndexField;
import org.eclipse.smila.search.templates.messages.searchtemplates.DSearchTemplates;
import org.eclipse.smila.search.templates.messages.searchtemplates.DSearchTemplatesCodec;
import org.eclipse.smila.search.templates.messages.searchtemplates.DSearchTemplatesException;
import org.eclipse.smila.search.templates.messages.searchtemplates.DTemplate;
import org.eclipse.smila.search.utils.advsearch.IQueryExpression;
import org.eclipse.smila.search.utils.advsearch.ITerm;
import org.eclipse.smila.search.utils.search.DField;
import org.eclipse.smila.search.utils.search.DQuery;
import org.eclipse.smila.utils.config.ConfigUtils;
import org.eclipse.smila.utils.xml.XMLUtils;
import org.eclipse.smila.utils.xml.XMLUtilsConfig;
import org.eclipse.smila.utils.xml.XMLUtilsException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class TemplateRegistryController {
    private static Hashtable<String, DSearchTemplates> s_searchTemplates = new Hashtable(0);
    private static Hashtable<String, DFieldTemplates> s_fieldTemplates = new Hashtable(0);

    private TemplateRegistryController() {
    }

    public static DTemplate getTemplate(DQuery dQuery) throws TemplateException {
        DSearchTemplates templates = TemplateRegistryController.getSearchTemplates(dQuery.getIndexName());
        int i = 0;
        while (i < templates.getTemplateCount()) {
            DTemplate template = templates.getTemplate(i);
            if (TemplateRegistryController.doesQueryMatchTemplate(dQuery, template)) {
                return template;
            }
            ++i;
        }
        return null;
    }

    public static DFieldTemplate getFieldTemplate(DQuery query, DField field, String indexName) throws TemplateException {
        DFieldTemplates templates = TemplateRegistryController.getFieldTemplates(indexName);
        int i = 0;
        while (i < templates.getTemplateCount()) {
            DFieldTemplate template = templates.getTemplate(i);
            if (TemplateRegistryController.doesFieldMatchTemplate(query, field, template)) {
                try {
                    return (DFieldTemplate)template.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {}
            }
            ++i;
        }
        return null;
    }

    static boolean doesQueryMatchTemplate(DQuery query, DTemplate template) {
        if (query == null) {
            throw new NullPointerException("query");
        }
        if (template == null) {
            throw new NullPointerException("template");
        }
        org.eclipse.smila.search.templates.messages.searchtemplates.DSelector dSelector = template.getSelector();
        String selector = "";
        if (dSelector.getName() != null) {
            selector = dSelector.getName().trim();
        }
        String templateSelectorName = "";
        if (query.getTemplateSelectorName() != null) {
            templateSelectorName = query.getTemplateSelectorName().trim();
        }
        if (query.getFieldsCount() != dSelector.getIndexFieldCount()) {
            return false;
        }
        if (!templateSelectorName.equals(selector)) {
            return false;
        }
        Iterator<DIndexField> fields = dSelector.getIndexFields();
        while (fields.hasNext()) {
            DIndexField field = fields.next();
            if (TemplateRegistryController.isFieldInQuery(field, query)) continue;
            return false;
        }
        return true;
    }

    private static boolean isFieldInQuery(DIndexField indexField, DQuery query) {
        Enumeration enm = query.getFields();
        while (enm.hasMoreElements()) {
            DField field = (DField)enm.nextElement();
            if (field.getFieldNo() != indexField.getFieldNo()) continue;
            return true;
        }
        return false;
    }

    public static boolean doesFieldMatchTemplate(DQuery query, DField field, DFieldTemplate template) {
        if (query == null) {
            throw new NullPointerException("query");
        }
        if (field == null) {
            throw new NullPointerException("field");
        }
        if (template == null) {
            throw new NullPointerException("template");
        }
        Log log = LogFactory.getLog(TemplateRegistryController.class);
        DSelector dSelector = template.getSelector();
        if (dSelector == null) {
            throw new NullPointerException("template.selector");
        }
        String selector = "";
        if (dSelector.getName() != null) {
            selector = dSelector.getName().trim();
        }
        String fieldTemplate = "";
        if (field.getFieldTemplate() != null) {
            fieldTemplate = field.getFieldTemplate().trim();
        }
        if (fieldTemplate.equals(selector) && field.getFieldNo() == dSelector.getFieldNo()) {
            if (dSelector.getFilterExpression() != null && !"".equals(dSelector.getFilterExpression().trim())) {
                boolean matchesFilterExpression;
                try {
                    matchesFilterExpression = TemplateRegistryController.matchesFilterExpression(dSelector.getFilterExpression().trim(), query);
                }
                catch (TemplateException exception) {
                    log.error((Object)("unable to check template expression filter [" + template.getName() + "]"), (Throwable)exception);
                    return false;
                }
                return matchesFilterExpression;
            }
            return true;
        }
        return false;
    }

    public static boolean matchesFilterExpression(String filterExpression, DQuery query) throws TemplateException {
        if (filterExpression == null) {
            throw new NullPointerException("filterExpression");
        }
        if (query == null) {
            throw new NullPointerException("query");
        }
        if ("".equals(filterExpression.trim())) {
            return true;
        }
        String[] tokens = filterExpression.trim().split(";");
        HashSet<String> queryFields = new HashSet<String>();
        Enumeration fields = query.getFields();
        while (fields.hasMoreElements()) {
            queryFields.add(String.valueOf(((DField)fields.nextElement()).getFieldNo()));
        }
        HashSet<String> requiredFields = new HashSet<String>();
        HashSet<String> prohibitedFields = new HashSet<String>();
        int i = 0;
        while (i < tokens.length) {
            String token = tokens[i].trim();
            if (token.length() > 0) {
                String number = token;
                if (token.startsWith("!")) {
                    number = token.substring(1);
                    prohibitedFields.add(number);
                } else {
                    requiredFields.add(number);
                }
                try {
                    Integer.parseInt(number);
                }
                catch (NumberFormatException exception) {
                    throw new TemplateException("unable to check for filter expression", exception);
                }
            }
            ++i;
        }
        for (String field : requiredFields) {
            if (queryFields.contains(field)) continue;
            return false;
        }
        for (String field : prohibitedFields) {
            if (!queryFields.contains(field)) continue;
            return false;
        }
        return true;
    }

    public static IQueryExpression applyTemplate(DQuery dQuery, DTemplate dTemplate, IndexConnection ic) throws TemplateException, NodeTransformerException, IndexException {
        Plugin plugin = PluginFactory.getPlugin();
        return plugin.getTemplateAccess().applyTemplate(dQuery, dTemplate, ic);
    }

    public static ITerm applyFieldTemplate(DField dField, DFieldTemplate dTemplate, IndexConnection ic) throws TemplateException, NodeTransformerException, IndexException {
        Plugin plugin = PluginFactory.getPlugin();
        return plugin.getTemplateAccess().applyFieldTemplate(dField, dTemplate, ic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSearchTemplates(DSearchTemplates templates) throws TemplateException {
        Hashtable<String, DSearchTemplates> hashtable = s_searchTemplates;
        synchronized (hashtable) {
            if (s_searchTemplates.containsKey(templates.getIndexName())) {
                s_searchTemplates.put(templates.getIndexName(), templates);
            }
            TemplateRegistryController.saveTemplateToDisk(templates);
        }
    }

    private static void saveTemplateToDisk(DSearchTemplates templates) throws TemplateException {
        Log log = LogFactory.getLog(TemplateRegistryController.class);
        File file = TemplateRegistryController.getSearchTemplateFile(templates.getIndexName());
        try {
            Document doc = DSearchTemplatesCodec.encode(templates);
            XMLUtils.stream((Element)doc.getDocumentElement(), (boolean)true, (String)"UTF-8", (File)file);
        }
        catch (Exception e) {
            s_searchTemplates.remove(templates.getIndexName());
            log.error((Object)("unable to store templates [" + templates.getIndexName() + "] in file [" + file.getName() + "]"), (Throwable)e);
            throw new TemplateException("unable to store templates [" + templates.getIndexName() + "]", e);
        }
    }

    private static File getSearchTemplateFile(String indexName) {
        File folder = ConfigUtils.getConfigFolder((String)"org.eclipse.smila.search", (String)"xml");
        File file = new File(folder, "SearchTemplates-" + indexName + ".xml");
        return file;
    }

    private static File getFieldTemplateFile(String indexName) {
        File folder = ConfigUtils.getConfigFolder((String)"org.eclipse.smila.search", (String)"xml");
        File file = new File(folder, "FieldTemplates-" + indexName + ".xml");
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DSearchTemplates getSearchTemplates(String indexName) throws TemplateException {
        Log log = LogFactory.getLog(TemplateRegistryController.class);
        TemplateRegistryController.checkIndexExistance(indexName);
        Hashtable<String, DSearchTemplates> hashtable = s_searchTemplates;
        synchronized (hashtable) {
            if (s_searchTemplates.containsKey(indexName)) {
                return s_searchTemplates.get(indexName);
            }
            DSearchTemplates templates = null;
            File file = TemplateRegistryController.getSearchTemplateFile(indexName);
            if (!file.exists()) {
                templates = new DSearchTemplates();
                templates.setIndexName(indexName);
                TemplateRegistryController.saveTemplateToDisk(templates);
            } else {
                try {
                    Document doc = XMLUtils.parse((File)file, (XMLUtilsConfig)new XMLUtilsConfig());
                    templates = DSearchTemplatesCodec.decode(doc.getDocumentElement());
                }
                catch (XMLUtilsException e) {
                    log.error((Object)e.getMessage());
                    throw new TemplateException("unable parse templates file [" + file.getName() + "]", e);
                }
                catch (DSearchTemplatesException e) {
                    log.error((Object)("unable to load templates file [" + file.getName() + "]"), (Throwable)e);
                    throw new TemplateException("unable decode templates file [" + file.getName() + "]", e);
                }
            }
            s_searchTemplates.put(indexName, templates);
            return templates;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFieldTemplates(DFieldTemplates templates) throws TemplateException {
        Hashtable<String, DFieldTemplates> hashtable = s_fieldTemplates;
        synchronized (hashtable) {
            if (s_fieldTemplates.containsKey(templates.getIndexName())) {
                s_fieldTemplates.put(templates.getIndexName(), templates);
            }
            TemplateRegistryController.saveTemplateToDisk(templates);
        }
    }

    private static void saveTemplateToDisk(DFieldTemplates templates) throws TemplateException {
        Log log = LogFactory.getLog(TemplateRegistryController.class);
        File file = TemplateRegistryController.getFieldTemplateFile(templates.getIndexName());
        try {
            Document doc = DFieldTemplatesCodec.encode(templates);
            XMLUtils.stream((Element)doc.getDocumentElement(), (boolean)true, (String)"UTF-8", (File)file);
        }
        catch (Exception e) {
            s_fieldTemplates.remove(templates.getIndexName());
            log.error((Object)("unable to store templates [" + templates.getIndexName() + "] in file [" + file.getName() + "]"), (Throwable)e);
            throw new TemplateException("unable to store templates [" + templates.getIndexName() + "]", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DFieldTemplates getFieldTemplates(String indexName) throws TemplateException {
        Log log = LogFactory.getLog(TemplateRegistryController.class);
        TemplateRegistryController.checkIndexExistance(indexName);
        Hashtable<String, DFieldTemplates> hashtable = s_fieldTemplates;
        synchronized (hashtable) {
            if (s_fieldTemplates.containsKey(indexName)) {
                return s_fieldTemplates.get(indexName);
            }
            DFieldTemplates templates = null;
            File file = TemplateRegistryController.getFieldTemplateFile(indexName);
            if (!file.exists()) {
                templates = new DFieldTemplates();
                templates.setIndexName(indexName);
                TemplateRegistryController.saveTemplateToDisk(templates);
            } else {
                try {
                    Document doc = XMLUtils.parse((File)file, (XMLUtilsConfig)new XMLUtilsConfig());
                    templates = DFieldTemplatesCodec.decode(doc.getDocumentElement());
                }
                catch (XMLUtilsException e) {
                    log.error((Object)e.getMessage());
                    throw new TemplateException("unable to parse templates file [" + file.getName() + "]", e);
                }
                catch (DFieldTemplatesException e) {
                    log.error((Object)("unable to load templates file [" + file.getName() + "]: " + e.getMessage()), (Throwable)e);
                    throw new TemplateException("unable to decode templates file [" + file.getName() + "]", e);
                }
            }
            s_fieldTemplates.put(indexName, templates);
            return templates;
        }
    }

    private static void checkIndexExistance(String indexName) throws TemplateException {
        boolean indexExists = false;
        try {
            indexExists = DataDictionaryController.hasIndex((String)indexName);
        }
        catch (Throwable e) {
            throw new TemplateException("index does not exist [" + indexName + "]", e);
        }
        if (!indexExists) {
            throw new TemplateException("index does not exist [" + indexName + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTemplates(String indexName, boolean doSearchTemplates, boolean doFieldTemplates) {
        Hashtable<String, Object> hashtable;
        File file;
        if (doSearchTemplates) {
            file = TemplateRegistryController.getSearchTemplateFile(indexName);
            file.delete();
            hashtable = s_searchTemplates;
            synchronized (hashtable) {
                s_searchTemplates.remove(indexName);
            }
        }
        if (doFieldTemplates) {
            file = TemplateRegistryController.getFieldTemplateFile(indexName);
            file.delete();
            hashtable = s_fieldTemplates;
            synchronized (hashtable) {
                s_fieldTemplates.remove(indexName);
            }
        }
    }
}

