/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.templates.messages.fieldtemplates;

import org.eclipse.smila.search.plugin.Plugin;
import org.eclipse.smila.search.plugin.PluginFactory;
import org.eclipse.smila.search.templates.messages.fieldtemplates.DFieldTemplate;
import org.eclipse.smila.search.templates.messages.fieldtemplates.DFieldTemplatesException;
import org.eclipse.smila.search.templates.messages.fieldtemplates.DSelectorCodec;
import org.eclipse.smila.search.utils.advsearch.AdvSearchException;
import org.eclipse.smila.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

abstract class DFieldTemplateCodec {
    private DFieldTemplateCodec() {
    }

    public static Element encode(DFieldTemplate dFieldTemplate, Element parent) throws DFieldTemplatesException {
        if (parent == null) {
            throw new DFieldTemplatesException("parameter must not be null [parent]");
        }
        if (dFieldTemplate == null) {
            throw new DFieldTemplatesException("parameter must not be null [dFieldTemplate]");
        }
        Document doc = parent.getOwnerDocument();
        Element el = doc.createElementNS("http://www.anyfinder.de/FieldTemplates", "FieldTemplate");
        el.setAttribute("Name", dFieldTemplate.getName());
        Element elTemp = null;
        elTemp = doc.createElementNS("http://www.anyfinder.de/FieldTemplates", "Description");
        elTemp.appendChild(doc.createCDATASection(dFieldTemplate.getDescription()));
        el.appendChild(elTemp);
        DSelectorCodec.encode(dFieldTemplate.getSelector(), el);
        try {
            Plugin plugin = PluginFactory.getPlugin();
            plugin.getAdvSearchAccess().encodeTerm(dFieldTemplate.getTerm(), el);
        }
        catch (AdvSearchException e) {
            throw new DFieldTemplatesException(e.getMessage());
        }
        parent.appendChild(el);
        return el;
    }

    public static DFieldTemplate decode(Element element) throws DFieldTemplatesException {
        if (element == null) {
            throw new DFieldTemplatesException("parameter must not be null [element]");
        }
        DFieldTemplate dFieldTemplate = new DFieldTemplate();
        dFieldTemplate.setName(element.getAttribute("Name"));
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i) instanceof Element) {
                Element el = (Element)nl.item(i);
                if ("Description".equals(el.getLocalName())) {
                    dFieldTemplate.setDescription(el.getTextContent());
                } else if ("Selector".equals(el.getLocalName())) {
                    dFieldTemplate.setSelector(DSelectorCodec.decode(el));
                } else if ("Term".equals(el.getLocalName())) {
                    try {
                        XMLUtils.removeWhitespaceTextNodes((Element)el);
                        Plugin plugin = PluginFactory.getPlugin();
                        dFieldTemplate.setTerm(plugin.getAdvSearchAccess().decodeTerm(el));
                    }
                    catch (Throwable e) {
                        throw new DFieldTemplatesException(e.getMessage());
                    }
                }
            }
            ++i;
        }
        return dFieldTemplate;
    }
}

