/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.templates.messages.fieldtemplates;

import org.eclipse.smila.search.templates.messages.fieldtemplates.DFieldTemplatesException;
import org.eclipse.smila.search.templates.messages.fieldtemplates.DSelector;
import org.eclipse.smila.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class DSelectorCodec {
    private DSelectorCodec() {
    }

    public static Element encode(DSelector dSelector, Element parent) throws DFieldTemplatesException {
        if (parent == null) {
            throw new DFieldTemplatesException("parameter must not be null [parent]");
        }
        if (dSelector == null) {
            throw new DFieldTemplatesException("parameter must not be null [dSelector]");
        }
        Document doc = parent.getOwnerDocument();
        Element el = doc.createElementNS("http://www.anyfinder.de/FieldTemplates", "Selector");
        el.setAttribute("FieldNo", XMLUtils.encodeInteger((int)dSelector.getFieldNo()));
        if (dSelector.getName() != null) {
            el.setAttribute("Name", dSelector.getName());
        }
        if (dSelector.getFilterExpression() != null) {
            Element elTemp = doc.createElementNS("http://www.anyfinder.de/FieldTemplates", "FilterExpression");
            elTemp.appendChild(doc.createCDATASection(dSelector.getFilterExpression()));
            el.appendChild(elTemp);
        }
        parent.appendChild(el);
        return el;
    }

    public static DSelector decode(Element element) throws DFieldTemplatesException {
        if (element == null) {
            throw new DFieldTemplatesException("parameter must not be null [element]");
        }
        DSelector dSelector = new DSelector();
        dSelector.setFieldNo(XMLUtils.decodeInteger((String)element.getAttribute("FieldNo")));
        dSelector.setName(element.getAttribute("Name"));
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Element el;
            if (nl.item(i) instanceof Element && "FilterExpression".equals((el = (Element)nl.item(i)).getLocalName())) {
                dSelector.setFilterExpression(el.getTextContent());
            }
            ++i;
        }
        return dSelector;
    }
}

