/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.utils.advsearch;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.smila.search.utils.advsearch.AdvSearchException;
import org.eclipse.smila.search.utils.advsearch.IAdvSearch;
import org.eclipse.smila.search.utils.advsearch.ITerm;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AdvSearchAccess {
    public static final String EXTENSION_POINT_NAME_ADV_SEARCH_ACCESS = "org.eclipse.smila.search.utils.advsearch.access";
    public static String NS = "http://www.anyfinder.de/AdvancedSearch";
    private static AdvSearchAccess[] s_cachedAdvSearchAccess;

    public static AdvSearchAccess getInstance() {
        AdvSearchAccess[] types;
        block5: {
            Log log = LogFactory.getLog(AdvSearchAccess.class);
            try {
                types = AdvSearchAccess.getTypes();
                if (types.length == 1) break block5;
                if (log.isWarnEnabled()) {
                    log.warn((Object)("invalid index structure access count [" + types.length + "]"));
                }
                return null;
            }
            catch (AdvSearchException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)e);
                }
                return null;
            }
        }
        return types[0];
    }

    public static AdvSearchAccess[] getTypes() throws AdvSearchException {
        if (s_cachedAdvSearchAccess != null) {
            return s_cachedAdvSearchAccess;
        }
        Log log = LogFactory.getLog(AdvSearchAccess.class);
        ArrayList<AdvSearchAccess> found = new ArrayList<AdvSearchAccess>();
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_NAME_ADV_SEARCH_ACCESS).getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] configElements = extension.getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                IConfigurationElement configurationElement = configElements[j];
                AdvSearchAccess.parseType(configurationElement, found.size());
                AdvSearchAccess clazz = null;
                try {
                    Object obj = configurationElement.createExecutableExtension("Clazz");
                    clazz = (AdvSearchAccess)obj;
                }
                catch (Exception exception) {
                    if (log.isErrorEnabled()) {
                        if (configurationElement != null) {
                            log.error((Object)"Failed to instantiate adv. search access");
                        } else {
                            log.error((Object)"Unknown!");
                        }
                    }
                    throw new AdvSearchException("unable to load adv. search access", exception);
                }
                if (clazz != null) {
                    found.add(clazz);
                }
                ++j;
            }
            ++i;
        }
        s_cachedAdvSearchAccess = found.toArray(new AdvSearchAccess[0]);
        return s_cachedAdvSearchAccess;
    }

    public static String parseType(IConfigurationElement configurationElement, int ordinal) {
        Log log = LogFactory.getLog(AdvSearchAccess.class);
        if (!configurationElement.getName().equals("SearchAdvAccess")) {
            return null;
        }
        try {
            String name = configurationElement.getAttribute("Clazz");
            if (name == null) {
                name = "[missing attribute name]";
            }
            return name;
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                String name = configurationElement.getAttribute("Clazz");
                if (name == null) {
                    name = "[missing attribute name]";
                }
                String msg = "Failed to load adv. search type named " + name + " in " + configurationElement.getDeclaringExtension().getNamespaceIdentifier();
                log.error((Object)msg, (Throwable)e);
            }
            return null;
        }
    }

    protected AdvSearchAccess() {
    }

    public abstract IAdvSearch decode(Element var1) throws AdvSearchException;

    public abstract ITerm decodeTerm(Element var1) throws AdvSearchException;

    public abstract Document encode(IAdvSearch var1) throws AdvSearchException;

    public abstract Element encode(IAdvSearch var1, Element var2) throws AdvSearchException;

    public abstract Element encodeTerm(ITerm var1, Element var2) throws AdvSearchException;
}

