/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.utils.search;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.eclipse.smila.search.utils.search.DDateField;
import org.eclipse.smila.search.utils.search.DFieldCodec;
import org.eclipse.smila.search.utils.search.DSearchException;
import org.eclipse.smila.search.utils.search.IDFParameter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class DDateFieldCodec {
    protected static DDateField decode(Element element) throws DSearchException {
        DDateField dDateField = new DDateField();
        DFieldCodec.decodeStandardValues(dDateField, element);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        GregorianCalendar c = new GregorianCalendar();
        try {
            c.setTime(sdf.parse(element.getAttribute("Minimum")));
        }
        catch (ParseException parseException) {
            throw new DSearchException("unable to decode date value [Minimum]");
        }
        dDateField.setDateMin(c);
        c = new GregorianCalendar();
        try {
            c.setTime(sdf.parse(element.getAttribute("Maximum")));
        }
        catch (ParseException parseException) {
            throw new DSearchException("unable to decode date value [Maximum]");
        }
        dDateField.setDateMax(c);
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if ("Parameter".equals(nl.item(i).getLocalName())) {
                dDateField.setParameter((IDFParameter)DFieldCodec.getParameter((Element)nl.item(i)));
            }
            ++i;
        }
        return dDateField;
    }

    protected static Element encode(DDateField dDateField, Element element) throws DSearchException {
        Document doc = element.getOwnerDocument();
        Element el = doc.createElementNS("http://www.anyfinder.de/Search", "Field");
        el.setAttribute("xsi:type", "FTDate");
        DFieldCodec.encodeStandardValues(dDateField, el);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = null;
        cal = dDateField.getDateMin();
        if (cal == null) {
            throw new DSearchException("minimum value not defined in date field");
        }
        el.setAttribute("Minimum", formatter.format(cal.getTime()));
        cal = dDateField.getDateMax();
        if (cal == null) {
            throw new DSearchException("maximum value not defined in date field");
        }
        el.setAttribute("Maximum", formatter.format(cal.getTime()));
        if (dDateField.getParameter() != null) {
            Class encoder = dDateField.getParameter().getCodecClass();
            Method m = null;
            if (encoder != null) {
                try {
                    m = encoder.getMethod("encode", IDFParameter.class, Element.class);
                }
                catch (NoSuchMethodException e) {
                    throw new DSearchException("unable to locate encoder method", e);
                }
                try {
                    m.invoke(null, dDateField.getParameter(), el);
                }
                catch (InvocationTargetException e) {
                    throw new DSearchException("unable to invoke encoder method", e);
                }
                catch (IllegalAccessException e) {
                    throw new DSearchException("unable to invoke encoder method", e);
                }
            }
        }
        element.appendChild(el);
        return el;
    }
}

