/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.db;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.AuthenticationService;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.store.replication.slave.SlaveFactory;
import org.apache.derby.impl.db.BasicDatabase;

public class SlaveDatabase
extends BasicDatabase {
    private volatile boolean inReplicationSlaveMode;
    private volatile boolean shutdownInitiated;
    private volatile boolean inBoot;
    private volatile StandardException bootException;
    private String dbname;
    private volatile SlaveFactory slaveFac;

    public boolean canSupport(Properties properties) {
        String string;
        boolean bl = Monitor.isDesiredCreateType(properties, this.getEngineType());
        if (bl && ((string = properties.getProperty("replication.slave.mode")) == null || !string.equals("slavemode"))) {
            bl = false;
        }
        return bl;
    }

    public void boot(boolean bl, Properties properties) throws StandardException {
        this.inReplicationSlaveMode = true;
        this.inBoot = true;
        this.shutdownInitiated = false;
        this.dbname = properties.getProperty("replication.slave.dbname");
        SlaveDatabaseBootThread slaveDatabaseBootThread = new SlaveDatabaseBootThread(bl, properties);
        Thread thread = new Thread((Runnable)slaveDatabaseBootThread, "derby.slave.boot-" + this.dbname);
        thread.setDaemon(true);
        thread.start();
        this.verifySuccessfulBoot();
        this.inBoot = false;
        this.active = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.inReplicationSlaveMode && this.slaveFac != null) {
            try {
                this.slaveFac.stopSlave(true);
            }
            catch (StandardException standardException) {
            }
            finally {
                this.slaveFac = null;
            }
        }
        super.stop();
    }

    public boolean isInSlaveMode() {
        return this.inReplicationSlaveMode;
    }

    public LanguageConnectionContext setupConnection(ContextManager contextManager, String string, String string2, String string3) throws StandardException {
        if (this.inReplicationSlaveMode) {
            throw StandardException.newException("08004.C.7", string3);
        }
        return super.setupConnection(contextManager, string, string2, string3);
    }

    public AuthenticationService getAuthenticationService() throws StandardException {
        if (this.inReplicationSlaveMode) {
            throw StandardException.newException("08004.C.7", this.dbname);
        }
        return super.getAuthenticationService();
    }

    public void verifyShutdownSlave() throws StandardException {
        if (!this.shutdownInitiated) {
            throw StandardException.newException("XRE43");
        }
        this.pushDbContext(ContextService.getFactory().getCurrentContextManager());
    }

    public void stopReplicationSlave() throws SQLException {
        if (this.shutdownInitiated) {
            return;
        }
        if (!this.inReplicationSlaveMode) {
            StandardException standardException = StandardException.newException("XRE40");
            throw PublicAPI.wrapStandardException(standardException);
        }
        try {
            this.slaveFac.stopSlave(false);
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
        this.slaveFac = null;
    }

    public void failover(String string) throws StandardException {
        if (this.inReplicationSlaveMode) {
            this.slaveFac.failover();
            while (this.inReplicationSlaveMode) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            super.failover(string);
        }
    }

    private void verifySuccessfulBoot() throws StandardException {
        while (!this.isSlaveFactorySet() || !this.slaveFac.isStarted()) {
            if (this.bootException != null) {
                throw this.bootException;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private boolean isSlaveFactorySet() {
        if (this.slaveFac != null) {
            return true;
        }
        try {
            this.slaveFac = (SlaveFactory)Monitor.findServiceModule(this, "org.apache.derby.iapi.store.replication.slave.SlaveFactory");
            return true;
        }
        catch (StandardException standardException) {
            return false;
        }
    }

    private void handleShutdown(StandardException standardException) {
        if (this.inBoot) {
            this.bootException = standardException;
            return;
        }
        try {
            this.shutdownInitiated = true;
            String string = "org.apache.derby.jdbc.EmbeddedDriver";
            Class.forName(string).newInstance();
            Driver driver = DriverManager.getDriver("jdbc:derby:");
            String string2 = "jdbc:derby:" + this.dbname + ";" + "internal_stopslave" + "=true";
            driver.connect(string2, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void bootBasicDatabase(boolean bl, Properties properties) throws StandardException {
        super.boot(bl, properties);
    }

    private class SlaveDatabaseBootThread
    implements Runnable {
        private boolean create;
        private Properties params;

        public SlaveDatabaseBootThread(boolean bl, Properties properties) {
            this.create = bl;
            this.params = properties;
        }

        public void run() {
            ContextManager contextManager = null;
            try {
                contextManager = ContextService.getFactory().newContextManager();
                ContextService.getFactory().setCurrentContextManager(contextManager);
                SlaveDatabase.this.bootBasicDatabase(this.create, this.params);
                SlaveDatabase.this.inReplicationSlaveMode = false;
                if (contextManager != null) {
                    ContextService.getFactory().resetCurrentContextManager(contextManager);
                    contextManager = null;
                }
            }
            catch (StandardException standardException) {
                SlaveDatabase.this.handleShutdown(standardException);
            }
        }
    }
}

