/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.queue.worker.internal.recycler;

import org.eclipse.smila.connectivity.queue.worker.RecordRecycler;
import org.eclipse.smila.management.DeclarativeServiceManagementAgent;

public class RecordRecyclerAgent
extends DeclarativeServiceManagementAgent<RecordRecycler> {
    protected String getCategory() {
        return "QueueWorker";
    }

    public String getName() {
        return "Recycler";
    }

    public void startRecycle(String configurationId, String dataSourceID) {
        try {
            ((RecordRecycler)this._service).recycleAsync(configurationId, dataSourceID);
        }
        catch (Throwable e) {
            e.printStackTrace();
            this._log.error((Object)"", e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public void stopRecycle(String dataSourceID) {
        try {
            ((RecordRecycler)this._service).stopRecycle(dataSourceID);
        }
        catch (Throwable e) {
            e.printStackTrace();
            this._log.error((Object)"", e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public String getStatus(String dataSourceID) {
        return ((RecordRecycler)this._service).getStatus(dataSourceID).toString();
    }

    public long getRecordsRecycled(String dataSourceID) {
        return ((RecordRecycler)this._service).getRecordsRecycled(dataSourceID);
    }

    public String[] getConfigurations() {
        try {
            return ((RecordRecycler)this._service).getConfigurations();
        }
        catch (Throwable e) {
            e.printStackTrace();
            this._log.error((Object)"", e);
            throw new RuntimeException(e.getMessage());
        }
    }
}

