/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.lucene.index.access;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.eclipse.smila.search.index.IndexException;
import org.eclipse.smila.search.lucene.index.access.ISynchronizedOperation;

public class GetDocumentOperation
implements ISynchronizedOperation<IndexSearcher, Document> {
    private final String _key;

    public GetDocumentOperation(String key) {
        this._key = key;
    }

    @Override
    public Document process(IndexSearcher object) throws IndexException {
        Hits hits;
        try {
            hits = object.search((Query)new TermQuery(new Term("##key", this._key)));
        }
        catch (IOException e) {
            throw new IndexException("Unable to search document [" + this._key + "]", (Throwable)e);
        }
        if (hits.length() == 0) {
            throw new IndexException("can not locate document [" + this._key + "]");
        }
        if (hits.length() > 1) {
            throw new IndexException("duplicate key [" + this._key + "] found in index (" + hits.length() + " occurrences)");
        }
        try {
            return hits.doc(0);
        }
        catch (Throwable e) {
            throw new IndexException("Unable to fetch first document [" + this._key + "]", e);
        }
    }
}

