/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.lucene.messages.indexstructure;

import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.smila.search.lucene.messages.indexstructure.DAnalyzer;
import org.eclipse.smila.search.lucene.messages.indexstructure.DIndexField;
import org.eclipse.smila.search.lucene.messages.indexstructure.DIndexStructureCodec;
import org.eclipse.smila.search.utils.search.DDateField;
import org.eclipse.smila.search.utils.search.DField;
import org.eclipse.smila.search.utils.search.DNumberField;
import org.eclipse.smila.search.utils.search.DTextField;
import org.eclipse.smila.utils.xml.XMLUtils;
import org.w3c.dom.Element;

public class DIndexStructure
extends org.eclipse.smila.search.utils.indexstructure.DIndexStructure {
    private final Hashtable<Long, org.eclipse.smila.search.utils.indexstructure.DIndexField> _fields = new Hashtable(0);
    private DAnalyzer _analyzer;

    public org.eclipse.smila.search.utils.indexstructure.DIndexField addField(org.eclipse.smila.search.utils.indexstructure.DIndexField dIndexField) {
        this._fields.put(new Long(dIndexField.getFieldNo()), dIndexField);
        return dIndexField;
    }

    public void removeField(DIndexField dIndexField) {
        this._fields.remove(new Long(dIndexField.getFieldNo()));
    }

    public org.eclipse.smila.search.utils.indexstructure.DIndexField removeField(int fieldNo) {
        return this._fields.remove(new Long(fieldNo));
    }

    public Iterator<org.eclipse.smila.search.utils.indexstructure.DIndexField> getFields() {
        return this._fields.values().iterator();
    }

    public org.eclipse.smila.search.utils.indexstructure.DIndexField getField(int fieldNo) {
        return this._fields.get(new Long(fieldNo));
    }

    public int getFieldCount() {
        return this._fields.size();
    }

    public DAnalyzer getAnalyzer() {
        return this._analyzer;
    }

    public void setAnalyzer(DAnalyzer analyzer) {
        this._analyzer = analyzer;
    }

    public String toString() {
        try {
            Element el = DIndexStructureCodec.encode(this, XMLUtils.getDocument().createElement("Dummy"));
            el.getOwnerDocument().appendChild(el);
            String s = new String(XMLUtils.stream((Element)el, (boolean)false));
            return s;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DIndexStructure)) {
            return false;
        }
        DIndexStructure o = (DIndexStructure)((Object)obj);
        if (!o.getName().equals(this.getName())) {
            return false;
        }
        DAnalyzer analA = this.getAnalyzer();
        DAnalyzer analB = o.getAnalyzer();
        if (analA == null && analB != null || analA != null && analB == null || analA != null && !analB.equals(analA)) {
            return false;
        }
        if (o.getFieldCount() != this.getFieldCount()) {
            return false;
        }
        int i = 0;
        while (i < this.getFieldCount()) {
            if (!o.getField(i).equals(this.getField(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equalsStructure(org.eclipse.smila.search.utils.indexstructure.DIndexStructure indexStructure, boolean throwException) {
        if (!(indexStructure instanceof DIndexStructure)) {
            return false;
        }
        DIndexStructure dIS = (DIndexStructure)indexStructure;
        DAnalyzer analA = this.getAnalyzer();
        DAnalyzer analB = dIS.getAnalyzer();
        if (analA == null && analB != null || analA != null && analB == null || analA != null && !analB.equals(analA)) {
            return false;
        }
        if (dIS.getFieldCount() != this.getFieldCount()) {
            return false;
        }
        int i = 0;
        while (i < this.getFieldCount()) {
            if (!dIS.getField(i).equals(this.getField(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean hasField(int fieldNo) {
        return this._fields.containsKey(new Long(fieldNo));
    }

    public boolean doesFieldTypeMatch(DField field) {
        int fieldNo = field.getFieldNo();
        if (this.hasField(fieldNo)) {
            DIndexField dIF = (DIndexField)this.getField(fieldNo);
            return field instanceof DTextField ? dIF.getType().equals("Text") : (field instanceof DNumberField ? dIF.getType().equals("Number") : field instanceof DDateField && dIF.getType().equals("Date"));
        }
        return false;
    }
}

