/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity;

import java.io.Serializable;
import org.eclipse.smila.utils.digest.DigestHelper;

public class ConnectivityId
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String _dataSourceId;
    private final String _objectId;
    private final ConnectivityId _containerId;
    private String _idHash;

    public ConnectivityId(String dataSourceId, String objectId) {
        this(dataSourceId, objectId, null);
    }

    public ConnectivityId(String dataSourceId, String objectId, ConnectivityId containerId) {
        this._dataSourceId = dataSourceId;
        this._objectId = containerId != null ? String.valueOf(containerId.getObjectId()) + ":<" + objectId + ">" : objectId;
        this._containerId = containerId;
    }

    public ConnectivityId(ConnectivityId parentId, String newObjectId) {
        this(parentId.getDataSourceId(), newObjectId, parentId);
    }

    public String getDataSourceId() {
        return this._dataSourceId;
    }

    public String getObjectId() {
        return this._objectId;
    }

    public ConnectivityId getContainerId() {
        return this._containerId;
    }

    public String getIdHash() {
        if (this._idHash == null) {
            String idString = this.toString();
            this._idHash = DigestHelper.calculateDigest((String)idString);
        }
        return this._idHash;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this._containerId == null ? 0 : this._containerId.hashCode());
        result = 31 * result + (this._dataSourceId == null ? 0 : this._dataSourceId.hashCode());
        result = 31 * result + (this._objectId == null ? 0 : this._objectId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectivityId)) {
            return false;
        }
        ConnectivityId other = (ConnectivityId)obj;
        if (this._containerId == null ? other._containerId != null : !this._containerId.equals(other._containerId)) {
            return false;
        }
        if (this._dataSourceId == null ? other._dataSourceId != null : !this._dataSourceId.equals(other._dataSourceId)) {
            return false;
        }
        return !(this._objectId == null ? other._objectId != null : !this._objectId.equals(other._objectId));
    }

    public String toString() {
        return "ConnectivityId [_dataSourceId=" + this._dataSourceId + ", _objectId=" + this._objectId + ", _containerId=" + this._containerId + "]";
    }
}

