/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2;

import java.util.concurrent.TimeoutException;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.axis2.OdeFault;
import org.apache.ode.axis2.soapbinding.SoapMessageConverter;
import org.apache.ode.bpel.iapi.BpelServer;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.InvocationStyle;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.il.epr.EndpointFactory;
import org.apache.ode.il.epr.MutableEndpoint;
import org.apache.ode.il.epr.WSAEndpoint;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.GUID;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ODEService {
    private static final Log __log = LogFactory.getLog(ODEService.class);
    public static final String TARGET_SESSION_ENDPOINT = "targetSessionEndpoint";
    public static final String CALLBACK_SESSION_ENDPOINT = "callbackSessionEndpoint";
    private AxisService _axisService;
    private BpelServer _server;
    private ProcessConf _pconf;
    private Definition _wsdlDef;
    private QName _serviceName;
    private String _portName;
    private WSAEndpoint _serviceRef;
    private SoapMessageConverter _converter;

    public ODEService(AxisService axisService, ProcessConf processConf, QName qName, String string, BpelServer bpelServer) throws AxisFault {
        this._axisService = axisService;
        this._server = bpelServer;
        this._serviceName = qName;
        this._pconf = processConf;
        this._wsdlDef = processConf.getDefinitionForService(qName);
        this._portName = string;
        this._serviceRef = EndpointFactory.convertToWSA((MutableEndpoint)ODEService.createServiceRef(ODEService.genEPRfromWSDL(this._wsdlDef, qName, string)));
        this._converter = new SoapMessageConverter(this._wsdlDef, qName, string);
    }

    public void onAxisMessageExchange(MessageContext messageContext, MessageContext messageContext2, SOAPFactory sOAPFactory) throws AxisFault {
        MyRoleMessageExchange myRoleMessageExchange = null;
        try {
            String string = new GUID().toString();
            myRoleMessageExchange = this._server.createMessageExchange(InvocationStyle.UNRELIABLE, this._serviceName, messageContext.getAxisOperation().getName().getLocalPart(), "" + string);
            __log.debug((Object)("ODE routed to operation " + myRoleMessageExchange.getOperation() + " from service " + this._serviceName));
            if (myRoleMessageExchange.getOperation() == null) {
                String string2 = "Call to " + this._serviceName + "." + myRoleMessageExchange.getOperationName() + " was not routable.";
                __log.error((Object)string2);
                throw new OdeFault(string2);
            }
            Message message = myRoleMessageExchange.createMessage(myRoleMessageExchange.getOperation().getInput().getMessage().getQName());
            this._converter.parseSoapRequest(message, messageContext.getEnvelope(), myRoleMessageExchange.getOperation());
            this.readHeader(messageContext, myRoleMessageExchange);
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Invoking ODE using MEX " + myRoleMessageExchange));
                __log.debug((Object)("Message content:  " + DOMUtils.domToString((Node)message.getMessage())));
            }
            myRoleMessageExchange.setRequest(message);
            myRoleMessageExchange.setTimeout(this.resolveTimeout());
            try {
                myRoleMessageExchange.invokeBlocking();
            }
            catch (TimeoutException timeoutException) {
                String string3 = "Call to " + this._serviceName + "." + myRoleMessageExchange.getOperationName() + " timed out.";
                __log.error((Object)string3, (Throwable)timeoutException);
                throw new OdeFault(string3);
            }
            if (myRoleMessageExchange.getOperation().getOutput() != null && messageContext2 != null) {
                SOAPEnvelope sOAPEnvelope = sOAPFactory.getDefaultEnvelope();
                messageContext2.setEnvelope(sOAPEnvelope);
                __log.debug((Object)("Handling response for MEX " + myRoleMessageExchange));
                this.onResponse(myRoleMessageExchange, messageContext2);
            }
        }
        catch (Exception exception) {
            String string = "Call to " + this._serviceName + "." + myRoleMessageExchange.getOperationName() + " caused an exception.";
            __log.error((Object)string, (Throwable)exception);
            throw new OdeFault(string, exception);
        }
        finally {
            if (myRoleMessageExchange != null) {
                try {
                    myRoleMessageExchange.release();
                }
                catch (Exception exception) {
                    __log.error((Object)("Error releasing message exchange: " + myRoleMessageExchange.getMessageExchangeId()));
                }
            }
        }
    }

    public boolean respondsTo(QName qName, QName qName2) {
        boolean bl = this._serviceName.equals(qName);
        bl = bl && this._wsdlDef.getService(this._serviceName).getPort(this._portName).getBinding().getPortType().getQName().equals(qName2);
        return bl;
    }

    private long resolveTimeout() {
        block3: {
            String string = (String)this._pconf.getEndpointProperties((EndpointReference)this._serviceRef).get("mex.timeout");
            if (string != null) {
                try {
                    return Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!__log.isWarnEnabled()) break block3;
                    __log.warn((Object)("Mal-formatted Property: [mex.timeout=" + string + "] Default value (" + 30000 + ") will be used"));
                }
            }
        }
        return 30000L;
    }

    private void onResponse(MyRoleMessageExchange myRoleMessageExchange, MessageContext messageContext) throws AxisFault {
        switch (myRoleMessageExchange.getAckType()) {
            case FAULT: {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Fault response message: " + myRoleMessageExchange.getFault()));
                }
                SOAPFault sOAPFault = this._converter.createSoapFault(myRoleMessageExchange.getFaultResponse().getMessage(), myRoleMessageExchange.getFault(), myRoleMessageExchange.getOperation());
                messageContext.getEnvelope().getBody().addFault(sOAPFault);
                if (!__log.isDebugEnabled()) break;
                __log.debug((Object)("Returning fault: " + messageContext.getEnvelope().toString()));
                break;
            }
            case ONEWAY: 
            case RESPONSE: {
                this._converter.createSoapResponse(messageContext, myRoleMessageExchange.getResponse(), myRoleMessageExchange.getOperation());
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Response message " + messageContext.getEnvelope()));
                }
                this.writeHeader(messageContext, myRoleMessageExchange);
                break;
            }
            case FAILURE: {
                throw new OdeFault("Message exchange failure");
            }
            default: {
                throw new OdeFault("Received ODE message exchange in unexpected state: " + myRoleMessageExchange.getStatus());
            }
        }
    }

    private void readHeader(MessageContext messageContext, MyRoleMessageExchange myRoleMessageExchange) {
        WSAEndpoint wSAEndpoint;
        Element element;
        Object object = messageContext.getProperty(TARGET_SESSION_ENDPOINT);
        Object object2 = messageContext.getProperty(CALLBACK_SESSION_ENDPOINT);
        if (object != null) {
            element = (Element)object;
            wSAEndpoint = new WSAEndpoint();
            wSAEndpoint.set((Node)element);
            myRoleMessageExchange.setProperty("org.apache.ode.bpel.myRoleSessionId", wSAEndpoint.getSessionId());
        }
        if (object2 != null) {
            element = (Element)object2;
            wSAEndpoint = new WSAEndpoint();
            wSAEndpoint.set((Node)element);
            myRoleMessageExchange.setProperty("org.apache.ode.bpel.partnerRoleSessionId", wSAEndpoint.getSessionId());
            myRoleMessageExchange.setProperty("org.apache.ode.bpel.partnerRoleEPR", DOMUtils.domToString((Node)element));
        }
    }

    private void writeHeader(MessageContext messageContext, MyRoleMessageExchange myRoleMessageExchange) {
        EndpointReference endpointReference = myRoleMessageExchange.getEndpointReference();
        if (endpointReference == null) {
            return;
        }
        if (myRoleMessageExchange.getProperty("org.apache.ode.bpel.myRoleSessionId") != null) {
            WSAEndpoint wSAEndpoint = new WSAEndpoint(this._serviceRef);
            wSAEndpoint.setSessionId(myRoleMessageExchange.getProperty("org.apache.ode.bpel.myRoleSessionId"));
            messageContext.setProperty(CALLBACK_SESSION_ENDPOINT, (Object)wSAEndpoint);
        }
    }

    public AxisService getAxisService() {
        return this._axisService;
    }

    public EndpointReference getMyServiceRef() {
        return this._serviceRef;
    }

    public static Element genEPRfromWSDL(Definition definition, QName qName, String string) {
        Port port;
        Service service = definition.getService(qName);
        if (service != null && (port = service.getPort(string)) != null) {
            Document document = DOMUtils.newDocument();
            Element element = document.createElementNS("http://schemas.xmlsoap.org/wsdl/", "service");
            element.setAttribute("name", service.getQName().getLocalPart());
            element.setAttribute("targetNamespace", service.getQName().getNamespaceURI());
            Element element2 = document.createElementNS("http://schemas.xmlsoap.org/wsdl/", "port");
            element.appendChild(element2);
            element2.setAttribute("name", port.getName());
            element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:bindns", port.getBinding().getQName().getNamespaceURI());
            element2.setAttribute("bindns:binding", port.getName());
            for (Object e : port.getExtensibilityElements()) {
                Element element3;
                if (e instanceof SOAPAddress) {
                    element3 = document.createElementNS("http://schemas.xmlsoap.org/wsdl/soap/", "address");
                    element2.appendChild(element3);
                    element3.setAttribute("location", ((SOAPAddress)e).getLocationURI());
                    continue;
                }
                if (e instanceof HTTPAddress) {
                    element3 = document.createElementNS("http://schemas.xmlsoap.org/wsdl/http/", "address");
                    element2.appendChild(element3);
                    element3.setAttribute("location", ((HTTPAddress)e).getLocationURI());
                    continue;
                }
                element2.appendChild(document.importNode(((UnknownExtensibilityElement)e).getElement(), true));
            }
            return element;
        }
        return null;
    }

    public static MutableEndpoint createServiceRef(Element element) {
        Document document = DOMUtils.newDocument();
        QName qName = new QName(element.getNamespaceURI(), element.getLocalName());
        if (!EndpointReference.SERVICE_REF_QNAME.equals(qName)) {
            Element element2 = document.createElementNS(EndpointReference.SERVICE_REF_QNAME.getNamespaceURI(), EndpointReference.SERVICE_REF_QNAME.getLocalPart());
            element2.appendChild(document.importNode(element, true));
            document.appendChild(element2);
        } else {
            document.appendChild(document.importNode(element, true));
        }
        return EndpointFactory.createEndpoint((Element)document.getDocumentElement());
    }
}

