/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.hooks;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.engine.AbstractDispatcher;
import org.apache.axis2.i18n.Messages;
import org.apache.commons.collections.map.MultiKeyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ODEAxisOperationDispatcher
extends AbstractDispatcher {
    private static MultiKeyMap _elmtToOperation = new MultiKeyMap();
    public static final String NAME = "ODEAxisOperationDispatcher";
    private static final Log log = LogFactory.getLog(ODEAxisOperationDispatcher.class);
    QName operationName = null;

    public AxisOperation findOperation(AxisService axisService, MessageContext messageContext) throws AxisFault {
        OMElement oMElement;
        AxisOperation axisOperation;
        String string = messageContext.getWSAAction();
        if (string != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage((String)"checkingoperation", (String)string));
            }
            if ((axisOperation = axisService.getOperationByAction(string)) != null) {
                return axisOperation;
            }
        }
        if ((oMElement = messageContext.getEnvelope().getBody().getFirstElement()) != null) {
            String string2;
            String string3 = oMElement.getLocalName();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking for Operation using SOAP message body's first child's local name : " + string3));
            }
            if ((axisOperation = axisService.getOperation(new QName(string3))) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found operation " + axisOperation));
                }
                return axisOperation;
            }
            int n = string3.lastIndexOf("Request");
            if (n >= 0 && n + "Request".length() == string3.length() && (string2 = axisService.getOperation(new QName(string3.substring(0, n)))) != null) {
                return string2;
            }
            n = string3.lastIndexOf("Response");
            if (n >= 0 && n + "Response".length() == string3.length() && (string2 = axisService.getOperation(new QName(string3.substring(0, n)))) != null) {
                return string2;
            }
            string2 = (String)_elmtToOperation.get((Object)axisService.getName(), (Object)string3);
            if (string2 != null) {
                axisOperation = axisService.getOperation(new QName(string2));
                return axisOperation;
            }
        }
        if (log.isWarnEnabled()) {
            log.warn((Object)"No operation has been found!");
        }
        return null;
    }

    public AxisService findService(MessageContext messageContext) throws AxisFault {
        return null;
    }

    public void initDispatcher() {
        this.init(new HandlerDescription(NAME));
    }

    public static void addElmtToOpMapping(String string, String string2, String string3) {
        if (string2.equals(string3)) {
            return;
        }
        _elmtToOperation.put((Object)string, (Object)string3, (Object)string2);
    }
}

