/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.hooks;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.receivers.AbstractMessageReceiver;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.axis2.ODEService;

public class ODEMessageReceiver
extends AbstractMessageReceiver {
    private static final Log __log = LogFactory.getLog(ODEMessageReceiver.class);
    private ODEService _service;

    public final void invokeBusinessLogic(MessageContext messageContext) throws AxisFault {
        if (this.hasResponse(messageContext.getAxisOperation())) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Received request message for " + messageContext.getAxisService().getName() + "." + messageContext.getAxisOperation().getName()));
            }
            MessageContext messageContext2 = MessageContextBuilder.createOutMessageContext((MessageContext)messageContext);
            messageContext2.getOperationContext().addMessageContext(messageContext2);
            this.invokeBusinessLogic(messageContext, messageContext2);
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Reply for " + messageContext.getAxisService().getName() + "." + messageContext.getAxisOperation().getName()));
                __log.debug((Object)("Reply message " + messageContext2.getEnvelope()));
            }
            AxisEngine.send((MessageContext)messageContext2);
        } else {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Received one-way message for " + messageContext.getAxisService().getName() + "." + messageContext.getAxisOperation().getName()));
            }
            this.invokeBusinessLogic(messageContext, null);
        }
    }

    private void invokeBusinessLogic(MessageContext messageContext, MessageContext messageContext2) throws AxisFault {
        this._service.onAxisMessageExchange(messageContext, messageContext2, this.getSOAPFactory(messageContext));
    }

    public void setService(ODEService oDEService) {
        this._service = oDEService;
    }

    private boolean hasResponse(AxisOperation axisOperation) {
        switch (axisOperation.getAxisSpecificMEPConstant()) {
            case 12: {
                return true;
            }
            case 14: {
                return true;
            }
            case 17: {
                return true;
            }
            case 15: {
                return true;
            }
        }
        return false;
    }
}

