/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.utils.extensions;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.smila.utils.extensions.AbstractPluginRegistryBase;

public abstract class AbstractCollectionPluginRegistry<T>
extends AbstractPluginRegistryBase<T> {
    protected Map<String, T> _pluginsMap;
    protected T[] _pluginsArray;
    private final Log _log = LogFactory.getLog(AbstractCollectionPluginRegistry.class);

    protected abstract T[] createEmptyArray(int var1);

    public T[] getPlugins() {
        return this._pluginsArray;
    }

    public T getPlugin(String id) {
        if (this._pluginsMap.containsKey(id)) {
            return this._pluginsMap.get(id);
        }
        return null;
    }

    @Override
    protected void initialize() {
        this._pluginsMap = new HashMap<String, T>();
        super.initialize();
    }

    @Override
    protected void extensionAdded(String id, IExtension extension) throws CoreException {
        if (id != null) {
            this.extensionRemoved(id);
            this._pluginsMap.put(id, this.createInstance(extension));
        } else {
            this._log.error((Object)"plug-in id is NULL");
        }
    }

    @Override
    protected void extensionRemoved(String id) {
        if (id != null) {
            if (this._pluginsMap.containsKey(id)) {
                this._pluginsMap.remove(id);
            }
        } else {
            this._log.error((Object)"plug-in id is NULL");
        }
    }

    @Override
    protected void finalizeExtensionChanges() {
        this._pluginsArray = this._pluginsMap.values().toArray(this.createEmptyArray(this._pluginsMap.values().size()));
    }
}

