/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler.v2.xquery10.compiler;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.xquery.XQConnection;
import javax.xml.xquery.XQConstants;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQSequence;
import javax.xml.xquery.XQStaticContext;
import net.sf.saxon.Configuration;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.xqj.SaxonXQConnection;
import net.sf.saxon.xqj.SaxonXQDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.WrappedResolverException;
import org.apache.ode.bpel.compiler.XPathMessages;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.bom.Expression;
import org.apache.ode.bpel.compiler.v2.CompilerContext;
import org.apache.ode.bpel.compiler.v2.ExpressionCompiler;
import org.apache.ode.bpel.compiler.v2.xpath10.XslCompilationErrorListener;
import org.apache.ode.bpel.compiler.v2.xpath20.JaxpFunctionResolver;
import org.apache.ode.bpel.compiler.v2.xpath20.JaxpVariableResolver;
import org.apache.ode.bpel.rtrep.v2.OConstantVarType;
import org.apache.ode.bpel.rtrep.v2.OElementVarType;
import org.apache.ode.bpel.rtrep.v2.OExpression;
import org.apache.ode.bpel.rtrep.v2.OLValueExpression;
import org.apache.ode.bpel.rtrep.v2.OMessageVarType;
import org.apache.ode.bpel.rtrep.v2.OScope;
import org.apache.ode.bpel.rtrep.v2.OVarType;
import org.apache.ode.bpel.rtrep.v2.OXsdTypeVarType;
import org.apache.ode.bpel.rtrep.v2.xpath10.OXPath10ExpressionBPEL20;
import org.apache.ode.bpel.rtrep.v2.xpath20.OXPath20ExpressionBPEL20;
import org.apache.ode.bpel.rtrep.v2.xquery10.OXQuery10ExpressionBPEL20;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.NSContext;
import org.apache.ode.utils.msg.MessageBundle;
import org.apache.ode.utils.xsl.XslTransformHandler;
import org.apache.xml.utils.XMLChar;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XQuery10ExpressionCompilerImpl
implements ExpressionCompiler {
    protected static final Log __log = LogFactory.getLog(XQuery10ExpressionCompilerImpl.class);
    protected String _bpelNS;
    protected QName _qnLinkStatus;
    protected QName _qnVarProp;
    protected QName _qnVarData;
    protected QName _qnXslTransform;
    protected final XPathMessages __msgs = (XPathMessages)MessageBundle.getMessages(XPathMessages.class);
    protected Map<String, String> _properties = new HashMap<String, String>();
    protected CompilerContext _compilerContext;

    public XQuery10ExpressionCompilerImpl(String string) {
        this._bpelNS = string;
        this._qnLinkStatus = new QName(this._bpelNS, "getLinkStatus");
        this._qnVarProp = new QName(this._bpelNS, "getVariableProperty");
        this._qnVarData = new QName(this._bpelNS, "getVariableData");
        this._qnXslTransform = new QName(this._bpelNS, "doXslTransform");
        this._properties.put("runtime-class", "org.apache.ode.bpel.rtrep.v2.xquery10.runtime.XQuery10ExpressionRuntime");
        TransformerFactoryImpl transformerFactoryImpl = new TransformerFactoryImpl();
        XslTransformHandler.getInstance().setTransformerFactory((TransformerFactory)transformerFactoryImpl);
    }

    @Override
    public void setCompilerContext(CompilerContext compilerContext) {
        this._compilerContext = compilerContext;
        XslCompilationErrorListener xslCompilationErrorListener = new XslCompilationErrorListener(compilerContext);
        XslTransformHandler.getInstance().setErrorListener((ErrorListener)xslCompilationErrorListener);
    }

    @Override
    public OExpression compileJoinCondition(Object object) throws CompilationException {
        return this._compile((Expression)object, true);
    }

    @Override
    public OExpression compile(Object object) throws CompilationException {
        return this._compile((Expression)object, false);
    }

    @Override
    public OLValueExpression compileLValue(Object object) throws CompilationException {
        return (OLValueExpression)this._compile((Expression)object, false);
    }

    private OExpression _compile(Expression expression, boolean bl) throws CompilationException {
        OXQuery10ExpressionBPEL20 oXQuery10ExpressionBPEL20 = new OXQuery10ExpressionBPEL20(this._compilerContext.getOProcess(), this._qnVarData, this._qnVarProp, this._qnLinkStatus, this._qnXslTransform, bl);
        oXQuery10ExpressionBPEL20.namespaceCtx = expression.getNamespaceContext();
        this.doJaxpCompile(oXQuery10ExpressionBPEL20, expression);
        return oXQuery10ExpressionBPEL20;
    }

    private void doJaxpCompile(OXQuery10ExpressionBPEL20 oXQuery10ExpressionBPEL20, Expression expression) throws CompilationException {
        Node node = expression.getExpression();
        if (node == null) {
            throw new IllegalStateException("XQuery string and xpath node are both null");
        }
        if (node.getNodeType() != 3 && node.getNodeType() != 1 && node.getNodeType() != 4) {
            throw new CompilationException(this.__msgs.errUnexpectedNodeTypeForXPath(DOMUtils.domToString((Node)node)));
        }
        String string = DOMUtils.domToString((Node)node);
        if ((string = string.trim()).length() == 0) {
            throw new CompilationException(this.__msgs.warnXPath20Syntax(DOMUtils.domToString((Node)node), "empty string"));
        }
        try {
            Object object;
            QName qName;
            Object object2;
            HashMap<QName, QName> hashMap22;
            List<OScope.Variable> list22;
            SaxonXQDataSource saxonXQDataSource = new SaxonXQDataSource();
            XQConnection xQConnection = saxonXQDataSource.getConnection();
            __log.debug((Object)("Compiling expression " + string));
            Configuration configuration = ((SaxonXQConnection)xQConnection).getConfiguration();
            configuration.setAllNodesUntyped(true);
            configuration.setHostLanguage(51);
            XQStaticContext xQStaticContext = xQConnection.getStaticContext();
            JaxpFunctionResolver jaxpFunctionResolver = new JaxpFunctionResolver(this._compilerContext, (OXPath20ExpressionBPEL20)oXQuery10ExpressionBPEL20, expression.getNamespaceContext(), this._bpelNS);
            JaxpVariableResolver jaxpVariableResolver = new JaxpVariableResolver(this._compilerContext, (OXPath10ExpressionBPEL20)oXQuery10ExpressionBPEL20);
            XQueryDeclarations xQueryDeclarations = new XQueryDeclarations();
            NSContext nSContext = expression.getNamespaceContext();
            Set set = nSContext.getPrefixes();
            if (!nSContext.getUriSet().contains("http://www.apache.org/ode/type/extension")) {
                nSContext.register("ode", "http://www.apache.org/ode/type/extension");
            }
            for (List<OScope.Variable> list22 : set) {
                hashMap22 = nSContext.getNamespaceURI((String)((Object)list22));
                xQStaticContext.declareNamespace((String)((Object)list22), (String)((Object)hashMap22));
                if ("".equals(list22)) {
                    xQueryDeclarations.declareDefaultElementNamespace((String)((Object)hashMap22));
                    continue;
                }
                if ("bpws".equals(list22)) {
                    xQueryDeclarations.declareNamespace("bpws", "java:org.apache.ode.bpel.compiler.v2.xquery10.compiler.XQuery10BpelFunctions");
                    continue;
                }
                xQueryDeclarations.declareNamespace((String)((Object)list22), (String)((Object)hashMap22));
            }
            xQueryDeclarations.declareVariable(this.getQName(nSContext, "http://www.apache.org/ode/type/extension", "pid"), this.getQName(nSContext, "http://www.w3.org/2001/XMLSchema", "integer"));
            Map<URI, Source> map = this._compilerContext.getSchemaSources();
            for (HashMap<QName, QName> hashMap22 : map.keySet()) {
                object2 = (Source)map.get(hashMap22);
            }
            configuration.setSchemaValidationMode(4);
            list22 = this._compilerContext.getAccessibleVariables();
            hashMap22 = new HashMap<QName, QName>();
            for (String qNameArray : this.getVariableNames(string)) {
                OScope.Variable variable = this.getVariable(list22, qNameArray);
                if (variable == null) continue;
                OVarType oVarType = variable.type;
                QName qName2 = this.getNameQName(qNameArray);
                qName = this.getTypeQName(qNameArray, oVarType);
                hashMap22.put(qName2, qName);
                object = qName.getPrefix();
                if (object == null || "".equals(((String)object).trim())) {
                    object = this.getPrefixForUri(nSContext, qName.getNamespaceURI());
                }
                xQueryDeclarations.declareVariable(qNameArray);
            }
            oXQuery10ExpressionBPEL20.xquery = xQueryDeclarations.toString() + string;
            xQConnection.setStaticContext(xQStaticContext);
            object2 = xQConnection.prepareExpression(oXQuery10ExpressionBPEL20.xquery);
            node.setUserData("function-resolver", jaxpFunctionResolver, null);
            object2.bindItem(XQConstants.CONTEXT_ITEM, xQConnection.createItemFromNode(node, xQConnection.createNodeType()));
            for (QName qName2 : object2.getAllUnboundExternalVariables()) {
                qName = (QName)hashMap22.get(qName2);
                object = jaxpVariableResolver.resolveVariable(qName2);
                if (qName == null) continue;
                if (object.getClass().getName().startsWith("java.lang")) {
                    object2.bindAtomicValue(qName2, object.toString(), xQConnection.createAtomicType(4));
                    continue;
                }
                if (object instanceof Node) {
                    object2.bindNode(qName2, (Node)object, xQConnection.createNodeType());
                    continue;
                }
                if (!(object instanceof NodeList)) continue;
                NodeList nodeList = (NodeList)object;
                ArrayList<Node> arrayList = new ArrayList<Node>();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    arrayList.add(nodeList.item(i));
                }
                XQSequence i = xQConnection.createSequence(arrayList.iterator());
                object2.bindSequence(qName2, i);
            }
            try {
                object2.executeQuery();
            }
            catch (XQException xQException) {}
        }
        catch (XQException xQException) {
            __log.debug((Object)xQException);
            __log.info((Object)("Couldn't validate properly expression " + string));
        }
        catch (WrappedResolverException wrappedResolverException) {
            if (wrappedResolverException._compilationMsg != null) {
                throw new CompilationException(wrappedResolverException._compilationMsg, (Throwable)wrappedResolverException);
            }
            if (wrappedResolverException.getCause() instanceof CompilationException) {
                throw (CompilationException)wrappedResolverException.getCause();
            }
            throw wrappedResolverException;
        }
    }

    @Override
    public Map<String, String> getProperties() {
        return this._properties;
    }

    private String getQName(NSContext nSContext, String string, String string2) {
        String string3 = this.getPrefixForUri(nSContext, string);
        return string3 == null ? string2 : string3 + ":" + string2;
    }

    private String getPrefixForUri(NSContext nSContext, String string) {
        Set set = nSContext.getPrefixes();
        for (String string2 : set) {
            String string3 = nSContext.getNamespaceURI(string2);
            if (string3 == null || !string3.equals(string)) continue;
            return string2;
        }
        return null;
    }

    private List<String> getVariableNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.indexOf("$");
        while (n != -1) {
            StringBuffer stringBuffer = new StringBuffer();
            char c = string.charAt(++n);
            while (XMLChar.isNCName((int)c)) {
                stringBuffer.append(c);
                c = string.charAt(++n);
            }
            arrayList.add(stringBuffer.toString());
            string = string.substring(n);
            n = string.indexOf("$");
        }
        return arrayList;
    }

    private OScope.Variable getVariable(List<OScope.Variable> list, String string) {
        String string2 = this.getVariableDeclaredName(string);
        for (OScope.Variable variable : list) {
            if (!variable.name.equals(string2)) continue;
            return variable;
        }
        return null;
    }

    private String getVariableDeclaredName(String string) {
        int n = string.indexOf(".");
        return n >= 0 ? string.substring(0, n) : string;
    }

    private String getVariablePartName(String string) {
        int n = string.indexOf(".");
        return n >= 0 ? string.substring(n + 1) : "";
    }

    private QName getNameQName(String string) {
        String string2 = null;
        String string3 = null;
        int n = string.indexOf(":");
        if (n >= 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        } else {
            string2 = "";
            string3 = string;
        }
        return new QName(string2, string3);
    }

    private QName getTypeQName(String string, OVarType oVarType) {
        QName qName = null;
        if (oVarType instanceof OConstantVarType) {
            qName = new QName("http://www.w3.org/2001/XMLSchema", "string", "xs");
        } else if (oVarType instanceof OElementVarType) {
            qName = ((OElementVarType)oVarType).elementType;
        } else if (oVarType instanceof OMessageVarType) {
            OMessageVarType.Part part = (OMessageVarType.Part)((OMessageVarType)oVarType).parts.get(this.getVariablePartName(string));
            if (part != null) {
                qName = this.getTypeQName(string, part.type);
            }
        } else if (oVarType instanceof OXsdTypeVarType) {
            qName = ((OXsdTypeVarType)oVarType).xsdType;
        }
        return qName;
    }

    private class XQueryDeclarations {
        StringBuffer declarations = new StringBuffer();

        public void declareVariable(String string, QName qName) {
            this.declareVariable(string, qName.getPrefix() + ":" + qName.getLocalPart());
        }

        public void declareVariable(String string, String string2) {
            this.declarations.append("declare variable ").append("$").append(string).append(" as ").append(string2).append(" external ").append(";\n");
        }

        public void declareVariable(String string) {
            this.declarations.append("declare variable ").append("$").append(string).append(" external ").append(";\n");
        }

        public void declareNamespace(String string, String string2) {
            this.declarations.append("declare namespace ").append(string).append("=").append("\"" + string2 + "\"").append(";\n");
        }

        public void declareDefaultElementNamespace(String string) {
            this.declarations.append("declare default element namespace ").append("\"" + string + "\"").append(";\n");
        }

        public String toString() {
            return this.declarations.toString();
        }
    }
}

