/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.ontology.pipelets;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.ontology.pipelets.ASesameRecordPipelet;
import org.eclipse.smila.ontology.records.SesameRecordReader;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.openrdf.model.URI;
import org.openrdf.repository.RepositoryConnection;

public class SesameRecordReaderPipelet
extends ASesameRecordPipelet {
    public static final String PARAM_INCLUDEINFERRED = "_includeInferred";
    public static final boolean DEFAULT_INCLUDEINFERRED = false;
    public static final String PARAM_URI_ATTRIBUTE = "_uriAttribute";
    public static final String PARAM_DEFAULT_URI_ATTRIBUTE = "rdf:about";
    private final Log _log = LogFactory.getLog(this.getClass());

    public String[] process(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        if (recordIds != null) {
            ParameterAccessor parameters = this.getParameters(blackboard);
            String[] stringArray = recordIds;
            int n = recordIds.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                try {
                    String resourceUri;
                    parameters.setCurrentRecord(id);
                    RepositoryConnection repoConn = this.getRepositoryConnection(parameters);
                    boolean includeInferred = parameters.getBooleanParameter(PARAM_INCLUDEINFERRED, Boolean.valueOf(false));
                    String uriAttribute = parameters.getParameter(PARAM_URI_ATTRIBUTE, PARAM_DEFAULT_URI_ATTRIBUTE);
                    AnyMap metadata = blackboard.getMetadata(id);
                    if (metadata.containsKey((Object)uriAttribute)) {
                        resourceUri = metadata.getStringValue(uriAttribute);
                    } else {
                        resourceUri = id.indexOf(58) > 0 && id.length() > id.indexOf(58) + 1 ? id.substring(id.indexOf(58) + 1) : id;
                        if (this._log.isWarnEnabled()) {
                            this._log.warn((Object)("Cannot determine the URI. I will use the URI derived from the ID: " + resourceUri));
                        }
                    }
                    URI uri = repoConn.getValueFactory().createURI(resourceUri);
                    SesameRecordReader reader = new SesameRecordReader(repoConn, includeInferred);
                    String recordFilterName = parameters.getParameter("_recordFilter", null);
                    if (recordFilterName == null) {
                        reader.readBlackboardRecord(uri, blackboard, id);
                    } else {
                        Record ontoRecord = reader.readRecord(uri);
                        ontoRecord.setId(id);
                        ontoRecord = blackboard.filterRecord(ontoRecord, recordFilterName);
                        blackboard.synchronizeRecord(ontoRecord);
                    }
                    repoConn.close();
                }
                catch (Exception ex) {
                    throw new ProcessingException("error reading record from ontology", (Throwable)ex);
                }
                ++n2;
            }
        }
        return recordIds;
    }
}

