/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v2;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.extension.ExtensionBundleRuntime;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.rapi.OdeRTInstance;
import org.apache.ode.bpel.rapi.OdeRuntime;
import org.apache.ode.bpel.rapi.ProcessModel;
import org.apache.ode.bpel.rapi.PropertyAliasModel;
import org.apache.ode.bpel.rapi.PropertyExtractor;
import org.apache.ode.bpel.rtrep.common.ConfigurationException;
import org.apache.ode.bpel.rtrep.v2.BoundVariableEvaluationContext;
import org.apache.ode.bpel.rtrep.v2.ExpressionLanguageRuntimeRegistry;
import org.apache.ode.bpel.rtrep.v2.Messages;
import org.apache.ode.bpel.rtrep.v2.OExpression;
import org.apache.ode.bpel.rtrep.v2.OExpressionLanguage;
import org.apache.ode.bpel.rtrep.v2.OProcess;
import org.apache.ode.bpel.rtrep.v2.PropertyAliasEvaluationContext;
import org.apache.ode.bpel.rtrep.v2.ReplacementMapImpl;
import org.apache.ode.bpel.rtrep.v2.RuntimeInstanceImpl;
import org.apache.ode.jacob.soup.ReplacementMap;
import org.apache.ode.jacob.vpu.ExecutionQueueImpl;
import org.apache.ode.utils.msg.MessageBundle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeImpl
implements OdeRuntime {
    private static final Log __log = LogFactory.getLog(RuntimeImpl.class);
    private static final Messages __msgs = (Messages)MessageBundle.getMessages(Messages.class);
    ProcessConf _pconf;
    OProcess _oprocess;
    Set<String> _mustUnderstandExtensions;
    ReplacementMap _replacementMap;
    ExpressionLanguageRuntimeRegistry _expLangRuntimeRegistry;
    Map<String, ExtensionBundleRuntime> _extensionRegistry;

    public void init(ProcessConf processConf, ProcessModel processModel) {
        this._pconf = processConf;
        this._oprocess = (OProcess)processModel;
        this._replacementMap = new ReplacementMapImpl(this._oprocess);
        ExpressionLanguageRuntimeRegistry expressionLanguageRuntimeRegistry = new ExpressionLanguageRuntimeRegistry();
        for (OExpressionLanguage oBase : this._oprocess.expressionLanguages) {
            try {
                expressionLanguageRuntimeRegistry.registerRuntime(oBase);
            }
            catch (ConfigurationException configurationException) {
                String string = __msgs.msgExpLangRegistrationError(oBase.expressionLanguageUri, oBase.properties);
                __log.error((Object)string, (Throwable)configurationException);
                throw new BpelEngineException(string, (Throwable)configurationException);
            }
        }
        this._expLangRuntimeRegistry = expressionLanguageRuntimeRegistry;
        this._mustUnderstandExtensions = new HashSet<String>();
        for (OProcess.OExtension oExtension : this._oprocess.declaredExtensions) {
            if (oExtension.mustUnderstand) {
                if (this._extensionRegistry.get(oExtension.namespaceURI) == null) {
                    String string = __msgs.msgExtensionMustUnderstandError(this._pconf.getProcessId(), oExtension.namespaceURI);
                    __log.error((Object)string);
                    throw new BpelEngineException(string);
                }
                this._mustUnderstandExtensions.add(oExtension.namespaceURI);
                continue;
            }
            __log.warn((Object)("The process declares the extension namespace " + oExtension.namespaceURI + " that is unkown to the engine"));
        }
    }

    public OdeRTInstance newInstance(Object object) {
        return new RuntimeInstanceImpl(this, (ExecutionQueueImpl)object);
    }

    public ReplacementMap getReplacementMap(QName qName) {
        if (this._pconf.getProcessId().equals(qName)) {
            return new ReplacementMapImpl(this._oprocess);
        }
        throw new UnsupportedOperationException("Implement the creation of replacement map for other version.");
    }

    public ProcessModel getModel() {
        return this._oprocess;
    }

    public String extractProperty(Element element, PropertyAliasModel propertyAliasModel, String string) throws FaultException {
        OProcess.OPropertyAlias oPropertyAlias = (OProcess.OPropertyAlias)propertyAliasModel;
        PropertyAliasEvaluationContext propertyAliasEvaluationContext = new PropertyAliasEvaluationContext(element, oPropertyAlias);
        Node node = propertyAliasEvaluationContext.getRootNode();
        if (oPropertyAlias.location != null) {
            node = this._expLangRuntimeRegistry.evaluateNode(oPropertyAlias.location, propertyAliasEvaluationContext);
        }
        if (node == null) {
            String string2 = __msgs.msgPropertyAliasReturnedNullSet(oPropertyAlias.getDescription(), string);
            if (__log.isErrorEnabled()) {
                __log.error((Object)string2);
            }
            throw new FaultException(this._oprocess.constants.qnSelectionFailure, string2);
        }
        if (node.getNodeType() == 1) {
            StringBuffer stringBuffer = new StringBuffer();
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                stringBuffer.append(node2.getNodeValue());
            }
            return stringBuffer.toString();
        }
        if (node.getNodeType() == 3) {
            return ((Text)node).getWholeText();
        }
        return null;
    }

    public String extractMatch(Element element, PropertyExtractor propertyExtractor) throws FaultException {
        OExpression oExpression = (OExpression)propertyExtractor;
        BoundVariableEvaluationContext boundVariableEvaluationContext = new BoundVariableEvaluationContext();
        boundVariableEvaluationContext.addBoundVariable(propertyExtractor.getMessageVariableName(), element);
        return ((Text)this._expLangRuntimeRegistry.evaluateNode(oExpression, boundVariableEvaluationContext)).getWholeText();
    }

    public void clear() {
        this._pconf = null;
        this._oprocess = null;
        this._mustUnderstandExtensions = null;
        this._replacementMap = null;
        this._expLangRuntimeRegistry = null;
        this._extensionRegistry = null;
    }

    public void setExtensionRegistry(Map<String, ExtensionBundleRuntime> map) {
        this._extensionRegistry = map;
    }
}

