/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.lucene.LuceneIndexService;
import org.eclipse.smila.search.api.SearchService;
import org.eclipse.smila.search.api.helper.QueryBuilder;
import org.eclipse.smila.search.api.internal.ResultDocumentBuilder;
import org.eclipse.smila.search.servlet.HttpRequestParser;
import org.eclipse.smila.search.servlet.MultiPartRequestParser;
import org.eclipse.smila.search.servlet.activator.Activator;
import org.eclipse.smila.utils.config.ConfigUtils;
import org.eclipse.smila.utils.xml.XMLUtils;
import org.eclipse.smila.utils.xml.XMLUtilsException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SMILASearchServlet
extends HttpServlet {
    public static final String DEFAULT_PIPELINE = "SearchPipeline";
    public static final String DEFAULT_STYLESHEET = "SMILASearchDefault";
    public static final String ELEMENT_INDEX_NAMES = "IndexNames";
    public static final String ELEMENT_INDEX_NAME = "IndexName";
    private static final long serialVersionUID = 1L;
    private final Log _log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private ServletFileUpload _fileUpload;
    private ResultDocumentBuilder _errorBuilder;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block15: {
            try {
                request.setCharacterEncoding("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new ServletException("unable to set request encoding to UTF-8");
            }
            boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
            QueryBuilder query = null;
            if (isMultipart) {
                try {
                    List items = this.getFileUploadParser().parseRequest(request);
                    MultiPartRequestParser parser = new MultiPartRequestParser(DEFAULT_PIPELINE);
                    query = parser.parse(items);
                }
                catch (FileUploadException ex) {
                    throw new ServletException("error parsing multipart request", (Throwable)ex);
                }
            } else {
                HttpRequestParser parser = new HttpRequestParser(DEFAULT_PIPELINE);
                query = parser.parse(request);
            }
            String showXml = query.getMetadata().getStringValue("showXml");
            SearchService searchService = Activator.getSearchService();
            Document resultDoc = null;
            try {
                if (searchService == null) {
                    resultDoc = this.getErrorBuilder().buildError((Exception)new ServletException("The SearchService is not available. Please wait a moment and try again."));
                } else {
                    resultDoc = query.executeRequestXml(searchService);
                    this.appendIndexList(resultDoc);
                }
            }
            catch (ParserConfigurationException ex) {
                throw new ServletException("Error creating an XML result to display. Something is completely wrong in the SMILA setup.", (Throwable)ex);
            }
            String stylesheet = query.getMetadata().getStringValue("style");
            if (StringUtils.isEmpty((String)stylesheet)) {
                stylesheet = DEFAULT_STYLESHEET;
            }
            try {
                byte[] result = null;
                if (showXml != null && Boolean.valueOf(showXml).booleanValue()) {
                    response.setContentType("text/xml");
                    result = XMLUtils.stream((Element)resultDoc.getDocumentElement(), (boolean)false);
                } else {
                    response.setContentType("text/html;charset=UTF-8");
                    result = this.transform(resultDoc, stylesheet);
                }
                response.getOutputStream().write(result);
                response.getOutputStream().flush();
            }
            catch (XMLUtilsException e) {
                if (!this._log.isErrorEnabled()) break block15;
                this._log.error((Object)"", (Throwable)e);
            }
        }
    }

    protected byte[] transform(Document doc, String stylesheet) throws ServletException {
        DOMSource xmlDomSource = new DOMSource(doc);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamResult stream = new StreamResult(baos);
        InputStream is = null;
        try {
            try {
                is = ConfigUtils.getConfigStream((String)"org.eclipse.smila.search.servlet", (String)(String.valueOf(stylesheet) + ".xsl"));
                Document xslDoc = XMLUtils.parse((InputStream)is, (boolean)false);
                Transformer transformer = this.getXSLTransformer(xslDoc);
                transformer.setParameter("stylesheet", stylesheet);
                transformer.transform(xmlDomSource, stream);
            }
            catch (XMLUtilsException xue) {
                throw new ServletException("the stylesheet is not valid [" + stylesheet + ".xsl]", (Throwable)xue);
            }
            catch (TransformerException te) {
                throw new ServletException("Error ocured while transforming!", (Throwable)te);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        return baos.toByteArray();
    }

    protected Transformer getXSLTransformer(Document xslDoc) throws ServletException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        if (tFactory.getFeature("http://javax.xml.transform.dom.DOMSource/feature") && tFactory.getFeature("http://javax.xml.transform.stream.StreamResult/feature")) {
            DOMSource xslDomSource = new DOMSource(xslDoc);
            try {
                return tFactory.newTransformer(xslDomSource);
            }
            catch (TransformerConfigurationException e) {
                throw new ServletException("error while creating the transformer", (Throwable)e);
            }
        }
        throw new ServletException("the transformer [" + tFactory.getClass().getName() + "] doesn't support the used DOMSource or StreamResult");
    }

    protected void appendIndexList(Document doc) {
        Iterator indexNames;
        LuceneIndexService indexService = Activator.getLuceneIndexService();
        if (indexService != null && (indexNames = indexService.getIndexNames()) != null) {
            Element indexNamesElement = doc.createElementNS("http://www.eclipse.org/smila/search", ELEMENT_INDEX_NAMES);
            while (indexNames.hasNext()) {
                String indexName = (String)indexNames.next();
                if (indexName == null) continue;
                Element nameElement = doc.createElement(ELEMENT_INDEX_NAME);
                nameElement.setTextContent(indexName);
                indexNamesElement.appendChild(nameElement);
            }
            doc.getDocumentElement().appendChild(indexNamesElement);
        }
    }

    protected synchronized ServletFileUpload getFileUploadParser() {
        if (this._fileUpload == null) {
            DiskFileItemFactory factory = new DiskFileItemFactory(Integer.MAX_VALUE, null);
            this._fileUpload = new ServletFileUpload((FileItemFactory)factory);
        }
        return this._fileUpload;
    }

    protected synchronized ResultDocumentBuilder getErrorBuilder() {
        if (this._errorBuilder == null) {
            this._errorBuilder = new ResultDocumentBuilder();
        }
        return this._errorBuilder;
    }
}

