/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.binarystorage.persistence.io;

import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.binarystorage.BinaryStorageException;
import org.eclipse.smila.binarystorage.config.BinaryStorageConfiguration;
import org.eclipse.smila.binarystorage.persistence.BinaryPersistence;
import org.eclipse.smila.binarystorage.persistence.io.BssIOUtils;

public abstract class IOBinaryPersistence
extends BinaryPersistence {
    private final Log _log = LogFactory.getLog(IOBinaryPersistence.class);

    public IOBinaryPersistence(BinaryStorageConfiguration binaryStorageConfig) throws BinaryStorageException {
        BssIOUtils.init(binaryStorageConfig);
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"Initializing fyle system manager for binary storage.");
        }
    }

    public void storeBinary(String key, byte[] content) throws BinaryStorageException {
        BssIOUtils.writeByteArrayToFile(key, content);
    }

    public void storeBinary(String key, InputStream stream) throws BinaryStorageException {
        BssIOUtils.writeInputStreamToFile(key, stream);
    }

    public byte[] loadBinaryAsByteArray(String key) throws BinaryStorageException {
        return BssIOUtils.readFileToByteArray(key);
    }

    public InputStream loadBinaryAsInputStream(String key) throws BinaryStorageException {
        return BssIOUtils.readFileToInputStream(key);
    }

    public void deleteBinary(String key) throws BinaryStorageException {
        BssIOUtils.deleteFile(key);
    }

    public long fetchSize(String key) throws BinaryStorageException {
        return BssIOUtils.fetchSize(key);
    }

    public void cleanup() throws BinaryStorageException {
    }
}

