/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.connectivity.ConnectivityException;
import org.eclipse.smila.connectivity.ConnectivityId;
import org.eclipse.smila.connectivity.ConnectivityManager;
import org.eclipse.smila.connectivity.deltaindexing.DeltaIndexingException;
import org.eclipse.smila.connectivity.deltaindexing.DeltaIndexingManager;
import org.eclipse.smila.connectivity.framework.CrawlState;
import org.eclipse.smila.connectivity.framework.Crawler;
import org.eclipse.smila.connectivity.framework.CrawlerCriticalException;
import org.eclipse.smila.connectivity.framework.CrawlerException;
import org.eclipse.smila.connectivity.framework.DataReference;
import org.eclipse.smila.connectivity.framework.State;
import org.eclipse.smila.connectivity.framework.compound.CompoundException;
import org.eclipse.smila.connectivity.framework.compound.CompoundManager;
import org.eclipse.smila.connectivity.framework.impl.JobIdHelper;
import org.eclipse.smila.connectivity.framework.performancecounters.CrawlerControllerPerformanceCounterHelper;
import org.eclipse.smila.connectivity.framework.schema.config.DataSourceConnectionConfig;
import org.eclipse.smila.connectivity.framework.util.CrawlThreadState;
import org.eclipse.smila.connectivity.framework.util.CrawlerControllerCallback;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.DataFactoryCreator;
import org.eclipse.smila.datamodel.Record;

public class CrawlThread
extends Thread {
    private static final int MAX_NON_CRICICAL_ATTEMPTS_TO_GET_INDEX = 1000;
    private static final DataFactory DATA_FACTORY = DataFactoryCreator.createDefaultFactory();
    private final Log _log = LogFactory.getLog(CrawlThread.class);
    private final CrawlerControllerCallback _controllerCallback;
    private final CrawlState _crawlState;
    private final ConnectivityManager _connectivityManager;
    private final DeltaIndexingManager _diManager;
    private final CompoundManager _compoundManager;
    private final Crawler _crawler;
    private final DataSourceConnectionConfig _configuration;
    private boolean _stopped;
    private CrawlerControllerPerformanceCounterHelper _performanceCounterHelper;
    private String _sessionId;
    private final ArrayList<Record> _recordBuffer = new ArrayList();
    private long _lastFlush;

    public CrawlThread(CrawlerControllerCallback controllerCallback, CrawlState crawlState, ConnectivityManager connectivityManager, DeltaIndexingManager diManager, CompoundManager compoundManager, Crawler crawler, DataSourceConnectionConfig configuration) throws DeltaIndexingException {
        DeltaIndexingManager.LockState state;
        if (controllerCallback == null) {
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)"Parameter controllerCallback is null");
            }
            throw new NullPointerException("Parameter controllerCallback is null");
        }
        if (crawlState == null) {
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)"Parameter crawlState is null");
            }
            throw new NullPointerException("Parameter crawlState is null");
        }
        if (connectivityManager == null) {
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)"Parameter connectivityManager is null");
            }
            throw new NullPointerException("parameter connectivityManager is null");
        }
        if (compoundManager == null) {
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)"Parameter compoundManager is null");
            }
            throw new NullPointerException("parameter connectivityManager is null");
        }
        if (crawler == null) {
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)"Parameter crawler is null");
            }
            throw new NullPointerException("parameter crawler is null");
        }
        if (controllerCallback.doDeltaIndexing(configuration.getDeltaIndexing()) && (state = (DeltaIndexingManager.LockState)diManager.getLockStates().get(configuration.getDataSourceID())) != null && state == DeltaIndexingManager.LockState.LOCKED) {
            throw new DeltaIndexingException("data source " + configuration.getDataSourceID() + " is already locked by another session");
        }
        if (this._log.isTraceEnabled()) {
            String msg = "Creating CrawlThread for dataSourceId " + configuration.getDataSourceID();
            this._log.trace((Object)msg);
        }
        this._controllerCallback = controllerCallback;
        this._crawlState = crawlState;
        this._connectivityManager = connectivityManager;
        this._diManager = diManager;
        this._compoundManager = compoundManager;
        this._crawler = crawler;
        this._configuration = configuration;
    }

    @Override
    public void run() {
        block57: {
            String msg;
            block64: {
                block63: {
                    block62: {
                        try {
                            if (this._controllerCallback.doDeltaIndexing(this._configuration.getDeltaIndexing())) {
                                this._sessionId = this._diManager.init(this._configuration.getDataSourceID());
                            }
                            try {
                                this._crawler.initialize(this._configuration);
                                this.getPerformanceCounterHelper().setJobId(this._crawlState.getJobId());
                                this.getPerformanceCounterHelper().setCrawlerStartDate(new Date(this._crawlState.getStartTime()));
                            }
                            catch (CrawlerException e) {
                                this.getPerformanceCounterHelper().addException((Throwable)e);
                                this._log.error((Object)"Non critical exception during crawler initialization", (Throwable)e);
                            }
                            this._lastFlush = System.currentTimeMillis();
                            while (!this._stopped) {
                                DataReference[] dataReferences = null;
                                int i = 0;
                                i = 0;
                                while (i < 1000) {
                                    try {
                                        dataReferences = this._crawler.getNext();
                                        break;
                                    }
                                    catch (CrawlerException e) {
                                        this.getPerformanceCounterHelper().addException((Throwable)e);
                                        this._log.error((Object)"Non critical exception during crawler getNext() call", (Throwable)e);
                                        ++i;
                                    }
                                }
                                if (dataReferences == null) {
                                    if (i < 999) break;
                                    this._log.error((Object)"Maximum noncritical errors reached");
                                    break;
                                }
                                this.processDataReferences(dataReferences);
                            }
                            if (!this._stopped) {
                                this.flushRecords();
                                if (this._crawlState.getLastError() == null) {
                                    this.deleteDelta(this._configuration.getDataSourceID());
                                }
                                this._crawlState.setState(CrawlThreadState.Finished);
                            } else {
                                this._crawlState.setState(CrawlThreadState.Stopped);
                            }
                        }
                        catch (CrawlerCriticalException e) {
                            String msg2;
                            block56: {
                                block55: {
                                    block54: {
                                        this.getPerformanceCounterHelper().addCriticalException((Throwable)e);
                                        this._log.error((Object)"", (Throwable)e);
                                        this._crawlState.setLastError((Throwable)e);
                                        this._crawlState.setState(CrawlThreadState.Aborted);
                                        try {
                                            this._crawler.close();
                                        }
                                        catch (CrawlerException e2) {
                                            this.getPerformanceCounterHelper().addException((Throwable)e2);
                                            if (!this._log.isErrorEnabled()) break block54;
                                            msg2 = "Error while closing Crawler after crawling dataSourceId " + this._configuration.getDataSourceID();
                                            this._log.error((Object)msg2, (Throwable)e2);
                                        }
                                    }
                                    if (this._controllerCallback.doDeltaIndexing(this._configuration.getDeltaIndexing())) {
                                        this._log.info((Object)("Removing deltaindexing lock on datasource " + this._configuration.getDataSourceID()));
                                        try {
                                            this._diManager.finish(this._sessionId);
                                            this._log.info((Object)("Finished session " + this._sessionId + " and removed Deltaindexing lock on datasource " + this._configuration.getDataSourceID()));
                                        }
                                        catch (Exception e3) {
                                            this.getPerformanceCounterHelper().addCriticalException((Throwable)e3);
                                            if (!this._log.isErrorEnabled()) break block55;
                                            msg2 = "Error while finishing DeltaIndexing after crawling dataSourceId " + this._configuration.getDataSourceID();
                                            this._log.error((Object)msg2, (Throwable)e3);
                                        }
                                    }
                                }
                                this._log.info((Object)("Unregistering crawling thread " + this._configuration.getDataSourceID()));
                                try {
                                    this._controllerCallback.unregister(this._configuration.getDataSourceID());
                                    this._log.info((Object)("Crawling thread " + this._configuration.getDataSourceID() + " unregistered"));
                                }
                                catch (Exception e4) {
                                    this.getPerformanceCounterHelper().addException((Throwable)e4);
                                    if (!this._log.isErrorEnabled()) break block56;
                                    msg2 = "Error while unregistering CrawlThread after crawling dataSourceId " + this._configuration.getDataSourceID();
                                    this._log.error((Object)msg2, (Throwable)e4);
                                }
                            }
                            try {
                                this._crawlState.setEndTime(Long.valueOf(System.currentTimeMillis()));
                                this.getPerformanceCounterHelper().setCrawlerEndDate(new Date(this._crawlState.getEndTime()));
                            }
                            catch (Exception e5) {
                                this.getPerformanceCounterHelper().addException((Throwable)e5);
                                if (this._log.isErrorEnabled()) {
                                    msg2 = "Error while settingend end time in CrawlState after crawling dataSourceId " + this._configuration.getDataSourceID();
                                    this._log.error((Object)msg2, (Throwable)e5);
                                }
                                break block57;
                            }
                        }
                        catch (Throwable e) {
                            try {
                                this.getPerformanceCounterHelper().addCriticalException(e);
                                this._log.error((Object)"", e);
                                this._crawlState.setLastError(e);
                                this._crawlState.setState(CrawlThreadState.Aborted);
                                break block57;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                block61: {
                                    String msg3;
                                    block60: {
                                        block59: {
                                            block58: {
                                                try {
                                                    this._crawler.close();
                                                }
                                                catch (CrawlerException e6) {
                                                    this.getPerformanceCounterHelper().addException((Throwable)e6);
                                                    if (!this._log.isErrorEnabled()) break block58;
                                                    msg3 = "Error while closing Crawler after crawling dataSourceId " + this._configuration.getDataSourceID();
                                                    this._log.error((Object)msg3, (Throwable)e6);
                                                }
                                            }
                                            if (this._controllerCallback.doDeltaIndexing(this._configuration.getDeltaIndexing())) {
                                                this._log.info((Object)("Removing deltaindexing lock on datasource " + this._configuration.getDataSourceID()));
                                                try {
                                                    this._diManager.finish(this._sessionId);
                                                    this._log.info((Object)("Finished session " + this._sessionId + " and removed Deltaindexing lock on datasource " + this._configuration.getDataSourceID()));
                                                }
                                                catch (Exception e7) {
                                                    this.getPerformanceCounterHelper().addCriticalException((Throwable)e7);
                                                    if (!this._log.isErrorEnabled()) break block59;
                                                    msg3 = "Error while finishing DeltaIndexing after crawling dataSourceId " + this._configuration.getDataSourceID();
                                                    this._log.error((Object)msg3, (Throwable)e7);
                                                }
                                            }
                                        }
                                        this._log.info((Object)("Unregistering crawling thread " + this._configuration.getDataSourceID()));
                                        try {
                                            this._controllerCallback.unregister(this._configuration.getDataSourceID());
                                            this._log.info((Object)("Crawling thread " + this._configuration.getDataSourceID() + " unregistered"));
                                        }
                                        catch (Exception e8) {
                                            this.getPerformanceCounterHelper().addException((Throwable)e8);
                                            if (!this._log.isErrorEnabled()) break block60;
                                            msg3 = "Error while unregistering CrawlThread after crawling dataSourceId " + this._configuration.getDataSourceID();
                                            this._log.error((Object)msg3, (Throwable)e8);
                                        }
                                    }
                                    try {
                                        this._crawlState.setEndTime(Long.valueOf(System.currentTimeMillis()));
                                        this.getPerformanceCounterHelper().setCrawlerEndDate(new Date(this._crawlState.getEndTime()));
                                    }
                                    catch (Exception e9) {
                                        this.getPerformanceCounterHelper().addException((Throwable)e9);
                                        if (!this._log.isErrorEnabled()) break block61;
                                        msg3 = "Error while settingend end time in CrawlState after crawling dataSourceId " + this._configuration.getDataSourceID();
                                        this._log.error((Object)msg3, (Throwable)e9);
                                    }
                                }
                            }
                        }
                        try {
                            this._crawler.close();
                        }
                        catch (CrawlerException e) {
                            this.getPerformanceCounterHelper().addException((Throwable)e);
                            if (!this._log.isErrorEnabled()) break block62;
                            msg = "Error while closing Crawler after crawling dataSourceId " + this._configuration.getDataSourceID();
                            this._log.error((Object)msg, (Throwable)e);
                        }
                    }
                    if (this._controllerCallback.doDeltaIndexing(this._configuration.getDeltaIndexing())) {
                        this._log.info((Object)("Removing deltaindexing lock on datasource " + this._configuration.getDataSourceID()));
                        try {
                            this._diManager.finish(this._sessionId);
                            this._log.info((Object)("Finished session " + this._sessionId + " and removed Deltaindexing lock on datasource " + this._configuration.getDataSourceID()));
                        }
                        catch (Exception e) {
                            this.getPerformanceCounterHelper().addCriticalException((Throwable)e);
                            if (!this._log.isErrorEnabled()) break block63;
                            msg = "Error while finishing DeltaIndexing after crawling dataSourceId " + this._configuration.getDataSourceID();
                            this._log.error((Object)msg, (Throwable)e);
                        }
                    }
                }
                this._log.info((Object)("Unregistering crawling thread " + this._configuration.getDataSourceID()));
                try {
                    this._controllerCallback.unregister(this._configuration.getDataSourceID());
                    this._log.info((Object)("Crawling thread " + this._configuration.getDataSourceID() + " unregistered"));
                }
                catch (Exception e) {
                    this.getPerformanceCounterHelper().addException((Throwable)e);
                    if (!this._log.isErrorEnabled()) break block64;
                    msg = "Error while unregistering CrawlThread after crawling dataSourceId " + this._configuration.getDataSourceID();
                    this._log.error((Object)msg, (Throwable)e);
                }
            }
            try {
                this._crawlState.setEndTime(Long.valueOf(System.currentTimeMillis()));
                this.getPerformanceCounterHelper().setCrawlerEndDate(new Date(this._crawlState.getEndTime()));
            }
            catch (Exception e) {
                this.getPerformanceCounterHelper().addException((Throwable)e);
                if (!this._log.isErrorEnabled()) break block57;
                msg = "Error while settingend end time in CrawlState after crawling dataSourceId " + this._configuration.getDataSourceID();
                this._log.error((Object)msg, (Throwable)e);
            }
        }
        this._log.info((Object)("Crawling thread " + this._configuration.getDataSourceID() + " stopped."));
    }

    /*
     * Exception decompiling
     */
    private void processDataReferences(DataReference[] dataReferences) throws CrawlerCriticalException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void stopCrawl() {
        this._stopped = true;
    }

    private CrawlerControllerPerformanceCounterHelper getPerformanceCounterHelper() {
        if (this._performanceCounterHelper == null) {
            this._performanceCounterHelper = new CrawlerControllerPerformanceCounterHelper(this._configuration, this._crawler.hashCode());
        }
        return this._performanceCounterHelper;
    }

    private long getAttachmentsByteLength(Record record) {
        if (!record.hasAttachments()) {
            return 0L;
        }
        long size = 0L;
        Iterator attachmentNames = record.getAttachmentNames();
        while (attachmentNames.hasNext()) {
            String attachmentName = (String)attachmentNames.next();
            byte[] attachment = record.getAttachment(attachmentName);
            if (attachment == null) continue;
            size += (long)attachment.length;
        }
        return size;
    }

    private Record processCompounds(Record record, DataSourceConnectionConfig config) throws CrawlerCriticalException {
        block20: {
            Crawler compoundCrawler = null;
            try {
                try {
                    compoundCrawler = this._compoundManager.extract(record, config);
                    if (compoundCrawler != null) {
                        while (!this._stopped) {
                            DataReference[] dataReferences = null;
                            int i = 0;
                            i = 0;
                            while (i < 1000) {
                                try {
                                    dataReferences = compoundCrawler.getNext();
                                    break;
                                }
                                catch (CrawlerException e) {
                                    this.getPerformanceCounterHelper().addException((Throwable)e);
                                    this._log.error((Object)"Non critical exception during compound crawler getNext() call", (Throwable)e);
                                    ++i;
                                }
                            }
                            if (dataReferences == null) {
                                if (i < 999) break;
                                this._log.error((Object)"Maximum noncritical errors reached");
                                break;
                            }
                            this.processDataReferences(dataReferences);
                        }
                    }
                    record = this._compoundManager.adaptCompoundRecord(record, config);
                }
                catch (CompoundException e) {
                    String msg = "Error during compound processing of record " + record.getId();
                    if (this._log.isErrorEnabled()) {
                        this._log.error((Object)msg, (Throwable)e);
                    }
                    if (compoundCrawler == null) break block20;
                    try {
                        compoundCrawler.close();
                    }
                    catch (CrawlerException e2) {
                        this.getPerformanceCounterHelper().addException((Throwable)e2);
                        if (this._log.isErrorEnabled()) {
                            String msg2 = "Error while closing CompoundCrawler while crawling dataSourceId " + this._configuration.getDataSourceID();
                            this._log.error((Object)msg2, (Throwable)e2);
                        }
                    }
                }
            }
            finally {
                block21: {
                    if (compoundCrawler != null) {
                        try {
                            compoundCrawler.close();
                        }
                        catch (CrawlerException e) {
                            this.getPerformanceCounterHelper().addException((Throwable)e);
                            if (!this._log.isErrorEnabled()) break block21;
                            String msg = "Error while closing CompoundCrawler while crawling dataSourceId " + this._configuration.getDataSourceID();
                            this._log.error((Object)msg, (Throwable)e);
                        }
                    }
                }
            }
        }
        return record;
    }

    private boolean isCompound(Record record, DataSourceConnectionConfig config) {
        block3: {
            if (config.getCompoundHandling() != null) {
                try {
                    return this._compoundManager.isCompound(record, config);
                }
                catch (CompoundException e) {
                    String msg = "Error while checking if record " + record.getId() + " is a compound";
                    if (!this._log.isErrorEnabled()) break block3;
                    this._log.error((Object)msg, (Throwable)e);
                }
            }
        }
        return false;
    }

    private int deleteDelta(String dataSourceId) {
        int count;
        block5: {
            count = 0;
            if (this._controllerCallback.doDeltaDelete(this._configuration.getDeltaIndexing())) {
                try {
                    Iterator it = this._diManager.obsoleteIdIterator(this._sessionId, dataSourceId);
                    if (it != null) {
                        while (it.hasNext()) {
                            ConnectivityId id = (ConnectivityId)it.next();
                            if (id == null) continue;
                            Record record = DATA_FACTORY.createRecord(id.getObjectId(), id.getDataSourceId());
                            JobIdHelper.setJobIdAttribute(record, (State)this._crawlState);
                            this._connectivityManager.delete(new Record[]{record});
                            this._diManager.delete(this._sessionId, id);
                            ++count;
                        }
                    }
                }
                catch (Exception e) {
                    String msg = "Error during execution of deleteDelta for dataSourceId " + dataSourceId;
                    if (!this._log.isErrorEnabled()) break block5;
                    this._log.error((Object)msg, (Throwable)e);
                }
            }
        }
        return count;
    }

    private void checkForFlush() throws ConnectivityException {
        if (this._recordBuffer.size() >= this._configuration.getRecordBuffer().getSize() || System.currentTimeMillis() - this._lastFlush > this._configuration.getRecordBuffer().getFlushInterval()) {
            this.flushRecords();
        }
    }

    private void flushRecords() throws ConnectivityException {
        if (!this._recordBuffer.isEmpty()) {
            try {
                this._lastFlush = System.currentTimeMillis();
                this._connectivityManager.add(this._recordBuffer.toArray(new Record[this._recordBuffer.size()]));
            }
            finally {
                this._recordBuffer.clear();
            }
        }
    }
}

