/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jms;

import javax.jms.ConnectionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.smila.jms.MQAccess;

public class ConnectionFactoryRegistry {
    private static final String EXTENTION_POINT_NAME = "org.eclipse.smila.jms";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_FACTORY_CLASS = "connectionFactoryClass";
    private static final Log LOG = LogFactory.getLog(ConnectionFactoryRegistry.class);

    private ConnectionFactoryRegistry() {
    }

    public static ConnectionFactory getConnectionFactory(String className, String brokerUrl, String userName, String password) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENTION_POINT_NAME);
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement configurationElement = extension.getConfigurationElements()[0];
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("FOUND CLASS " + configurationElement.getAttribute(ATTRIBUTE_FACTORY_CLASS)));
            }
            if (configurationElement.getAttribute(ATTRIBUTE_FACTORY_CLASS).equals(className)) {
                try {
                    MQAccess access = (MQAccess)configurationElement.createExecutableExtension(ATTRIBUTE_CLASS);
                    return access.newConnectionFactory(brokerUrl, userName, password);
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
            }
            ++n2;
        }
        throw new RuntimeException(String.format("Connection factory %s is not found", className));
    }
}

