/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.Body;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Header;
import org.apache.camel.Headers;
import org.apache.camel.Message;
import org.apache.camel.OutHeaders;
import org.apache.camel.Properties;
import org.apache.camel.Property;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.component.bean.AmbiguousMethodCallException;
import org.apache.camel.component.bean.AnnotationExpressionFactory;
import org.apache.camel.component.bean.DefaultParameterMappingStrategy;
import org.apache.camel.component.bean.MethodInfo;
import org.apache.camel.component.bean.MethodInvocation;
import org.apache.camel.component.bean.ParameterInfo;
import org.apache.camel.component.bean.ParameterMappingStrategy;
import org.apache.camel.language.LanguageAnnotation;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanInfo {
    private static final transient Log LOG = LogFactory.getLog(BeanInfo.class);
    private final CamelContext camelContext;
    private Class type;
    private ParameterMappingStrategy strategy;
    private Map<String, MethodInfo> operations = new ConcurrentHashMap<String, MethodInfo>();
    private MethodInfo defaultMethod;
    private List<MethodInfo> operationsWithBody = new ArrayList<MethodInfo>();
    private List<MethodInfo> operationsWithCustomAnnotation = new ArrayList<MethodInfo>();

    public BeanInfo(CamelContext camelContext, Class type) {
        this(camelContext, type, BeanInfo.createParameterMappingStrategy(camelContext));
    }

    public BeanInfo(CamelContext camelContext, Class type, ParameterMappingStrategy strategy) {
        this.camelContext = camelContext;
        this.type = type;
        this.strategy = strategy;
        this.introspect(this.getType());
        if (this.operations.size() == 1) {
            Collection<MethodInfo> methodInfos = this.operations.values();
            Iterator<MethodInfo> i$ = methodInfos.iterator();
            while (i$.hasNext()) {
                MethodInfo methodInfo;
                this.defaultMethod = methodInfo = i$.next();
            }
        }
    }

    public Class getType() {
        return this.type;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public MethodInvocation createInvocation(Method method, Object pojo, Exchange exchange) throws RuntimeCamelException {
        MethodInfo methodInfo = this.introspect(this.type, method);
        if (methodInfo != null) {
            return methodInfo.createMethodInvocation(pojo, exchange);
        }
        return null;
    }

    public MethodInvocation createInvocation(Object pojo, Exchange exchange) throws RuntimeCamelException, AmbiguousMethodCallException {
        MethodInfo methodInfo = null;
        String name = exchange.getIn().getHeader("org.apache.camel.MethodName", String.class);
        if (name != null) {
            methodInfo = this.operations.get(name);
        }
        if (methodInfo == null) {
            methodInfo = this.chooseMethod(pojo, exchange);
        }
        if (methodInfo == null) {
            methodInfo = this.defaultMethod;
        }
        if (methodInfo != null) {
            return methodInfo.createMethodInvocation(pojo, exchange);
        }
        return null;
    }

    protected void introspect(Class clazz) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!this.isValidMethod(clazz, method)) continue;
            this.introspect(clazz, method);
        }
        Class superclass = clazz.getSuperclass();
        if (superclass != null && !superclass.equals(Object.class)) {
            this.introspect(superclass);
        }
    }

    protected MethodInfo introspect(Class clazz, Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] parametersAnnotations = method.getParameterAnnotations();
        ArrayList<ParameterInfo> parameters = new ArrayList<ParameterInfo>();
        ArrayList<ParameterInfo> bodyParameters = new ArrayList<ParameterInfo>();
        boolean hasCustomAnnotation = false;
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            Annotation[] parameterAnnotations = parametersAnnotations[i];
            Expression expression = this.createParameterUnmarshalExpression(clazz, method, parameterType, parameterAnnotations);
            hasCustomAnnotation |= expression != null;
            ParameterInfo parameterInfo = new ParameterInfo(i, parameterType, parameterAnnotations, expression);
            parameters.add(parameterInfo);
            if (expression != null) continue;
            hasCustomAnnotation |= ObjectHelper.hasAnnotation(parameterAnnotations, Body.class);
            if (bodyParameters.isEmpty()) {
                expression = Exchange.class.isAssignableFrom(parameterType) ? ExpressionBuilder.exchangeExpression() : ExpressionBuilder.bodyExpression(parameterType);
                parameterInfo.setExpression(expression);
                bodyParameters.add(parameterInfo);
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No expression available for method: " + method.toString() + " which already has a body so ignoring parameter: " + i + " so ignoring method"));
            }
            return null;
        }
        String opName = method.getName();
        MethodInfo methodInfo = new MethodInfo(clazz, method, parameters, bodyParameters, hasCustomAnnotation);
        this.operations.put(opName, methodInfo);
        if (methodInfo.hasBodyParameter()) {
            this.operationsWithBody.add(methodInfo);
        }
        if (methodInfo.isHasCustomAnnotation() && !methodInfo.hasBodyParameter()) {
            this.operationsWithCustomAnnotation.add(methodInfo);
        }
        return methodInfo;
    }

    protected MethodInfo chooseMethod(Object pojo, Exchange exchange) throws AmbiguousMethodCallException {
        if (this.operationsWithBody.size() == 1) {
            return this.operationsWithBody.get(0);
        }
        if (!this.operationsWithBody.isEmpty()) {
            return this.chooseMethodWithMatchingBody(exchange, this.operationsWithBody);
        }
        if (this.operationsWithCustomAnnotation.size() == 1) {
            return this.operationsWithCustomAnnotation.get(0);
        }
        return null;
    }

    protected MethodInfo chooseMethodWithMatchingBody(Exchange exchange, Collection<MethodInfo> operationList) throws AmbiguousMethodCallException {
        Message in = exchange.getIn();
        Object body = in.getBody();
        if (body != null) {
            Class<?> bodyType = body.getClass();
            ArrayList<MethodInfo> possibles = new ArrayList<MethodInfo>();
            for (MethodInfo methodInfo : operationList) {
                boolean out = exchange.getPattern().isOutCapable();
                if (out && methodInfo.isReturnTypeVoid() || !methodInfo.bodyParameterMatches(bodyType)) continue;
                possibles.add(methodInfo);
            }
            if (possibles.size() == 1) {
                return (MethodInfo)possibles.get(0);
            }
            if (possibles.isEmpty()) {
                Object newBody = null;
                MethodInfo matched = null;
                for (MethodInfo methodInfo : operationList) {
                    Object value = ExchangeHelper.convertToType(exchange, methodInfo.getBodyParameterType(), body);
                    if (value == null) continue;
                    if (newBody != null) {
                        throw new AmbiguousMethodCallException(exchange, Arrays.asList(matched, methodInfo));
                    }
                    newBody = value;
                    matched = methodInfo;
                }
                if (matched != null) {
                    in.setBody(newBody);
                    return matched;
                }
            } else {
                if (this.operationsWithCustomAnnotation.size() == 1) {
                    return this.operationsWithCustomAnnotation.get(0);
                }
                return this.chooseMethodWithCustomAnnotations(exchange, possibles);
            }
        }
        return null;
    }

    protected MethodInfo chooseMethodWithCustomAnnotations(Exchange exchange, Collection<MethodInfo> possibles) throws AmbiguousMethodCallException {
        MethodInfo chosen = null;
        for (MethodInfo possible : possibles) {
            if (!possible.isHasCustomAnnotation()) continue;
            if (chosen != null) {
                chosen = null;
                break;
            }
            chosen = possible;
        }
        if (chosen != null) {
            return chosen;
        }
        throw new AmbiguousMethodCallException(exchange, possibles);
    }

    protected Expression createParameterUnmarshalExpression(Class clazz, Method method, Class parameterType, Annotation[] parameterAnnotation) {
        for (Annotation annotation : parameterAnnotation) {
            Expression answer = this.createParameterUnmarshalExpressionForAnnotation(clazz, method, parameterType, annotation);
            if (answer == null) continue;
            return answer;
        }
        return this.strategy.getDefaultParameterTypeExpression(parameterType);
    }

    protected boolean isPossibleBodyParameter(Annotation[] annotations) {
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                if (annotation instanceof Property || annotation instanceof Header || annotation instanceof Headers || annotation instanceof OutHeaders || annotation instanceof Properties) {
                    return false;
                }
                LanguageAnnotation languageAnnotation = annotation.annotationType().getAnnotation(LanguageAnnotation.class);
                if (languageAnnotation == null) continue;
                return false;
            }
        }
        return true;
    }

    protected Expression createParameterUnmarshalExpressionForAnnotation(Class clazz, Method method, Class parameterType, Annotation annotation) {
        if (annotation instanceof Property) {
            Property propertyAnnotation = (Property)annotation;
            return ExpressionBuilder.propertyExpression(propertyAnnotation.name());
        }
        if (annotation instanceof Properties) {
            return ExpressionBuilder.propertiesExpression();
        }
        if (annotation instanceof Header) {
            Header headerAnnotation = (Header)annotation;
            return ExpressionBuilder.headerExpression(headerAnnotation.name());
        }
        if (annotation instanceof Headers) {
            return ExpressionBuilder.headersExpression();
        }
        if (annotation instanceof OutHeaders) {
            return ExpressionBuilder.outHeadersExpression();
        }
        LanguageAnnotation languageAnnotation = annotation.annotationType().getAnnotation(LanguageAnnotation.class);
        if (languageAnnotation != null) {
            Class<?> type = languageAnnotation.factory();
            Object object = this.camelContext.getInjector().newInstance(type);
            if (object instanceof AnnotationExpressionFactory) {
                AnnotationExpressionFactory expressionFactory = (AnnotationExpressionFactory)object;
                return expressionFactory.createExpression(this.camelContext, annotation, languageAnnotation, parameterType);
            }
            LOG.error((Object)("Ignoring bad annotation: " + languageAnnotation + "on method: " + method + " which declares a factory: " + type.getName() + " which does not implement " + AnnotationExpressionFactory.class.getName()));
        }
        return null;
    }

    protected boolean isValidMethod(Class clazz, Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            return false;
        }
        return method.getReturnType() == null || !Exchange.class.isAssignableFrom(method.getReturnType());
    }

    public static ParameterMappingStrategy createParameterMappingStrategy(CamelContext camelContext) {
        Registry registry = camelContext.getRegistry();
        ParameterMappingStrategy answer = registry.lookup(ParameterMappingStrategy.class.getName(), ParameterMappingStrategy.class);
        if (answer == null) {
            answer = new DefaultParameterMappingStrategy();
        }
        return answer;
    }
}

